<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coal_getting_outbound extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('coal_getting_model');
		$this->bc->set_title('Coal Getting Outbound');
		$this->bc->add('Coal Getting',base_url().'coalgetting');
		$this->bc->add('Outbound',base_url().'coalgetting/coal_getting_outbound');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'outbound/main'
		);
		$this->load->view('tpl',$data);
	}

	function save()
	{
		$where = array();
        $where['tbl.vehicle_id'] = $this->input->post('t_vehicle_id');
        $where['tbl.coal_get_number'] = 'empty';
		$this->coal_getting_model->set_where($where);
		$coal_get_out = $this->coal_getting_model->get_list_get($where);	
		$recnum = $coal_get_out['id_rec']; 	
		
		$data = array();
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vehicle_number'] 	= $this->input->post('t_vehicle_number');
		$data['default_weight'] 	= $this->input->post('t_default_weight');
		$data['coal_get_status']	= 1;
		$data['coal_getout_date']	= date('Y-m-d');
		$data['coal_getout_time']	= date('H:i:s');
		$data['coal_get_number']	= 'empty';

		if ($recnum) {
			$data['id_rec']	  = $recnum;
		} else {
			$data['id_rec'] 	  = $this->coal_getting_model->gen_recnum($data['vehicle_id']);
		}
		
		$this->db->trans_start();
		$save = $this->coal_getting_model->save($data);
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->success('Simpan Berhasil');
		}
	}

	public function getDataCoalGettingOutbound()
	{
		$post = $this->input->post();
		
        $where = array();
        $where['tbl.vehicle_id'] = $post['vehicle_id'];
        $where['tbl.coal_get_number'] = 'empty';
		$this->coal_getting_model->set_where($where);

		$order = array();
		$order['tbl.id_rec'] = 'DESC';
		$this->coal_getting_model->set_order($order);

		$coal_get_out = $this->coal_getting_model->get_list_get($where);
		// echo $this->db->last_query();die;

        if (!$coal_get_out['vehicle_id']){
            $this->error('ID Kendaraan Tidak Ditemukan');
        }
        $tgl = date('Y-m-d');
        $jam = date('H:i:s');
        $this->result['coalgetout'] = $coal_get_out;
        $this->result['tgl'] = $tgl;
        $this->result['jam'] = $jam;
        $this->success('ok');		
	}

}