<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Hauling_model extends Base_Model
{

	function __construct()
	{

		parent::__construct();
		$this->set_table('hauling');
		$this->set_pk('vehicle_id','id_rec');
		$this->set_log(false);
	}

	function count()
	{
		$data = array();
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');
        $this->db->join('trans_status sts','tbl.hauling_status=sts.trans_status','left');
        $this->db->join('vehicle vhc','tbl.vehicle_id=vhc.vehicle_id','left');

		$this->db->where($this->where);
		$this->db->or_like($this->like);

		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
	
		return $query->num_rows();
	}

	function get_list()
	{
		$this->db->select('tbl.*');
		$this->db->select('vnd.vendor_name');
		$this->db->select('sts.status');
		$this->db->select('vhc.vendor_id as vehicle_vendorid');
		$this->db->select('vhc.tare_weight as vehicle_tare_weight');
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');
		$this->db->join('trans_status sts','tbl.hauling_status=sts.trans_status','left');
		$this->db->join('vehicle vhc','tbl.vehicle_id=vhc.vehicle_id','left');
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}


	function gen_transaction_number($prefix='')
	{
		$transnumber_length	= 16;
		
		$this->db->select('RIGHT(tbl.hauling_number,7) hauling_number',false);
		$this->db->order_by('tbl.hauling_number','DESC');
		$this->db->group_by('tbl.hauling_number');
		
		$prefix_length		= strlen($prefix);
		$autonumber_length	= $transnumber_length - $prefix_length;
		
		$this->db->where("LEFT(tbl.hauling_number,9) = '$prefix' AND CHAR_LENGTH(tbl.hauling_number) = $transnumber_length");
		
		$query = $this->db->get($this->schema.'.'.$this->table.' tbl','1','0');
		// echo $this->db->last_query();
		// exit;
		
		$no_last =  $query->row_array();
		$no_next = 1;
		if ($no_last)
		{
			$no_next = $no_last['hauling_number']+1;
		}

		$no = $prefix.sprintf('%0'.$autonumber_length.'s', $no_next);
	
		$query->free_result();
		
		return $no;
	} 

	public function gen_recnum($prefix)
	{
		$this->db->select('IFNULL( MAX( id_rec ), 0 ) + 1 last_recnum',false);
		$this->db->where(array('vehicle_id'=>$prefix));
		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		$query_row = $query->row_array();
		return $query_row['last_recnum'];
	}

	function get_list_summary()
	{
		$this->db->select('tbl.vendor_mis');
		$this->db->select('tbl.ongkos');
		$this->db->select('sum(tbl.gross_weight) as gross_weight',false);
		$this->db->select('sum(tbl.tare_weight) as tare_weight',false);
		$this->db->select('sum(tbl.net_weight) as net_weight',false);
		$this->db->group_by(array('tbl.vendor_mis','tbl.ongkos'));
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}


	function update_header($transnum,$date1,$date2,$vendor)
	{
		$qry = '
		UPDATE hauling
		SET hauling_recapnum = '.quotedStr($transnum).'
		    , hauling_status = 3 
		WHERE
		 hauling_status = 2
		 AND hauling_date BETWEEN '.quotedStr($date1).' 
		 AND '.quotedStr($date2).'
		 AND vendor_mis ='.quotedStr($vendor) ;
		$query = $this->db->query($qry);
	}

	public function get_startdate($transnum)
	{
		$this->db->select(' MIN(hauling_out_date) start_date',false);
		$this->db->where(array('hauling_recapnum'=>$transnum));
		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		$query_row = $query->row_array();
		return $query_row['start_date'];
	}

	public function get_enddate($transnum)
	{
		$this->db->select(' MAX(hauling_date) end_date',false);
		$this->db->where(array('hauling_recapnum'=>$transnum));
		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		$query_row = $query->row_array();
		return $query_row['end_date'];
	}


	function getTotalHauling()
	{
		$this->db->select('ifnull(sum(net_weight),0) as total',false);
		// $this->db->join('vendor vnd','tbl.vendor_mis=vnd.vendor_mis','left');

		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

        $query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		$query_sum = $query->row_array();
        return  $query_sum['total'];
	}

	function get_list_bymonth()
	{
		$this->db->select('MONTH(tbl.hauling_date) as ob_month');
		$this->db->select('MONTHNAME(tbl.hauling_date) as ob_month_name');
		$this->db->select('ifnull(sum(net_weight),0) as total',false);
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

		if($this->group_by)
		{
			foreach ($this->group_by as $value) {
				$this->db->group_by($value);
			}
		}
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}

	function get_list_byday()
	{
		$this->db->select('DAY(tbl.hauling_date) as ob_day');
		$this->db->select('ifnull(sum(net_weight),0) as total',false);
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

		if($this->group_by)
		{
			foreach ($this->group_by as $value) {
				$this->db->group_by($value);
			}
		}
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}

	function get_list_byhour()
	{
		$this->db->select('HOUR(tbl.hauling_time) as ob_hour');
		$this->db->select('ifnull(sum(net_weight),0) as total',false);
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

		if($this->group_by)
		{
			foreach ($this->group_by as $value) {
				$this->db->group_by($value);
			}
		}
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}

}
