<!DOCTYPE html>
<html>

<head>
    <link href="<?=base_url()?>assets/css/print-doc-html.css" rel="stylesheet">
    <title>Hauling Report Print</title>
</head>
<body>
<div class="container">
    <h3 class="text-center">Hauling Report</h3>
    <div class="row">
        <div class="col-12">
            <table style="width:100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="text-left" style="width: 20%;">Vendor</td>
                    <td class="text-left" style="width: 30%;">: <?=$data_hauling_recap['vendor_mis']?> - <?=$data_hauling_recap['vendor_name']?></td>
                    <td class="text-left" style="width: 20%;">Total Trafict</td>
                    <td class="text-left" style="width: 30%;">: <?=number_format($count_hauling)?> </td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Ongkos</td>
                    <td class="text-left" style="width: 30%;">: Rp. <?=number_format($data_hauling_recap['ongkos'])?> / Tons</td>
                    <td class="text-left" style="width: 20%;">Total Berat Bersih</td>
                    <td class="text-left" style="width: 30%;">: <?=number_format($data_hauling_recap['net_weight'],2)?> Tons / Rp. <?=number_format($data_hauling_recap['net_weight'] * $data_hauling_recap['ongkos'])?></td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Biaya Selisih</td>
                    <td class="text-left" style="width: 30%;">: Rp. <?=number_format($data_hauling_recap['biaya_selisih'])?> / Tons</td>
                    <td class="text-left" style="width: 20%;">Total Selisih Berat</td>
                    <td class="text-left" style="width: 30%;">: 0</td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Start</td>
                    <td class="text-left" style="width: 30%;">: <?= humanize_mdate($start_date) ?></td>
                    <td class="text-left" style="width: 20%;">Selisih harus diganti</td>
                    <td class="text-left" style="width: 30%;">: 0 Tons / Rp. 0</td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">End</td>
                    <td class="text-left" style="width: 30%;">: <?= humanize_mdate($end_date) ?></td>
                    <td class="text-left" style="width: 20%;">Total Tagihan</td>
                    <td class="text-left" style="width: 30%;">: Rp. <?=number_format($data_hauling_recap['net_weight'] * $data_hauling_recap['ongkos'])?></td>
                </tr>
            </table>
        </div>
    </div> <br>
    <div class="row">
        <div class="col-12">
            <table style="width:100%" cellspacing="0" cellpadding="0">
            <thead>
                <tr style="text-align:center" bgcolor="#b5d5eb">
                    <th rowspan="2">#Trafict</th>
                    <th rowspan="2">Nomor Hauling</th>
                    <th colspan="2">Kendaraan</th>
                    <th colspan="3">Berangkat</th>
                    <th colspan="3">Tiba di Jeti</th>
                    <th rowspan="2">Total Waktu</th>
                    <th rowspan="2">Selisih Berat Bersih</th>
                </tr>
                <tr style="text-align:center" bgcolor="#b5d5eb">
                    <th>ID</th>
                    <th>No. Polisi</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>Berat Bersih</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>Berat Bersih</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($data_hauling->num_rows() > 0) {
                    $i = 0;
                    foreach ($data_hauling->result_array() as $row) {
                        $i++;
                ?>
                        <tr>
                            <td class="bordered" style="text-align:center"><?= $i ?></td>
                            <td class="bordered" style="text-align:left"><?= $row['hauling_number'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['vehicle_id'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['vehicle_number'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= humanize_mdate($row['hauling_out_date']) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['hauling_out_time'] ?></td>                    
                            <td class="bordered" style="text-align:right"><?= number_format($row['net_weight'],2) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= humanize_mdate($row['hauling_date']) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['hauling_time'] ?></td>                    
                            <td class="bordered" style="text-align:right"><?= number_format($row['net_weight'],2) ?></td>         
                            
                            <?php 
                                $date1 = strtotime($row['hauling_out_date'] .' '. $row['hauling_out_time']) ;
                                $fromdate = date('Y-m-d H:m:s',$date1);

                                $date2 = strtotime($row['hauling_date'] .' '. $row['hauling_time']) ;
                                $untildate = date('Y-m-d H:m:s',$date2);

                                $d1 = new DateTime($fromdate);
                                $d2 = new DateTime($untildate);
                                $interval = $d2->diff($d1);
                                // echo $interval->format('%d days, %H hours, %I minutes, %S seconds');
                            ?>

                            <td class="bordered" style="text-align:center"><?= $interval->format('%d hari, %H jam') ?></td>                    
                            <td class="bordered" style="text-align:right"> 0 </td>                    
                        </tr>
                    <?php } ?>
                <?php } else { ?>
                    <tr>
                        <td class="bordered" colspan="12"><i>Data Tidak Ditemukan</i></td>
                    </tr>
                <?php } ?>
            </tbody>
            </table>
        </div>
    </div>
</div>    
</body>

<!-- halaman vendor subcon-->
<div style="page-break-after: always;"></div>
<body><br>   
<h4>Hauling Report Vendor Subcon</h4>
    <div class="row">
        <div class="col-12">
            <table style="width:100%" cellspacing="0" cellpadding="0">
            <thead>
                <tr style="text-align:center" bgcolor="#b5d5eb">
                    <th rowspan="2">No.</th>
                    <th rowspan="2">Nomor Hauling</th>
                    <th colspan="2">Kendaraan</th>
                    <th colspan="3">Berangkat</th>
                    <th colspan="3">Tiba di Jeti</th>
                    <th rowspan="2">Total Waktu</th>
                    <th rowspan="2">Selisih Berat Bersih</th>
                </tr>
                <tr style="text-align:center" bgcolor="#b5d5eb">
                    <th>ID</th>
                    <th>No. Polisi</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>Berat Bersih</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>Berat Bersih</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $noSubcon = 0;
                $no = 0;
                $saldo = 0; 
                if ($data_hauling_subcon->num_rows() > 0) {
                    $vendSubcon = '';
                    foreach ($data_hauling_subcon->result_array() as $row_subcon) {
                        $noSubcon++;
                        $no++;

                        $totalbwh = "<tr bgcolor= \"#ffffff \">
                                        <td colspan=\"6\"><b>TOTAL</b></td>
                                        <td style=\"text-align:right;\"><b>".number_format($saldo,2)."</b></td>
                                        <td colspan=\"2\"></td>
                                        <td style=\"text-align:right;\"><b>".number_format($saldo,2)."</b></td>
                                        <td colspan=\"2\"></td>
                                        </tr>";			

                        if($vendSubcon!=$row_subcon['vendor_subcon'])
                        {        
                            $saldo = 0;                   
				            
                            if($no!=1)
                                {
                                    echo $totalbwh;
                                }
                            echo "<tr><td  style=\"background-color: rgb(244, 222, 165);\" colspan=\"13\"><b> ".$row_subcon['vendor_subcon']."</b></td></tr>";
                            $vendSubcon = $row_subcon['vendor_subcon'];
                            $no=1;
                        }                        
                        $saldo = $saldo + $row_subcon['net_weight'];
                ?>
                        <tr>
                            <td class="bordered" style="text-align:center"><?= $no ?></td>
                            <td class="bordered" style="text-align:left"><?= $row_subcon['hauling_number'] ?></td>                
                            <td class="bordered" style="text-align:center"><?= $row_subcon['vehicle_id'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row_subcon['vehicle_number'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= humanize_mdate($row_subcon['hauling_out_date']) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row_subcon['hauling_out_time'] ?></td>                    
                            <td class="bordered" style="text-align:right"><?= number_format($row_subcon['net_weight'],2) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= humanize_mdate($row_subcon['hauling_date']) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row_subcon['hauling_time'] ?></td>                    
                            <td class="bordered" style="text-align:right"><?= number_format($row_subcon['net_weight'],2) ?></td>         
                            
                            <?php 
                                $date1 = strtotime($row_subcon['hauling_out_date'] .' '. $row_subcon['hauling_out_time']) ;
                                $fromdate = date('Y-m-d H:m:s',$date1);

                                $date2 = strtotime($row_subcon['hauling_date'] .' '. $row_subcon['hauling_time']) ;
                                $untildate = date('Y-m-d H:m:s',$date2);

                                $d1 = new DateTime($fromdate);
                                $d2 = new DateTime($untildate);
                                $interval = $d2->diff($d1);
                                // echo $interval->format('%d days, %H hours, %I minutes, %S seconds');
                            ?>

                            <td class="bordered" style="text-align:center"><?= $interval->format('%d hari, %H jam') ?></td>                    
                            <td class="bordered" style="text-align:right"> 0 </td>                    
                        </tr>
                    <?php 
                        if($noSubcon==$data_hauling_subcon->num_rows()) {
                            $totalbwh = "<tr bgcolor= \"#ffffff \">
                                        <td colspan=\"6\"><b>TOTAL</b></td>
                                        <td style=\"text-align:right;\"><b>".number_format($saldo,2)."</b></td>
                                        <td colspan=\"2\"></td>
                                        <td style=\"text-align:right;\"><b>".number_format($saldo,2)."</b></td>
                                        <td colspan=\"2\"></td>
                                        </tr>";			
                                        echo $totalbwh; }
                        // echo "<tfoot><tr><td  style=\"background-color: rgb(244, 222, 165);\" colspan=\"13\"><b> ".$saldo."</b></td></tr></tfoot>"; } 
                        $vendSubcon = $row_subcon['vendor_subcon'];  }?>
                <?php } else { ?>
                    <tr>
                        <td class="bordered" colspan="13"><i>Data Tidak Ditemukan</i></td>
                    </tr>
                <?php } ?>
            </tbody>
            </table>
        </div>
    </div>

</body>

</html>
<style>
    @page {
        margin: 20px 40px 20px 40px !important;
    }
    table{
        border: none;
        border-collapse: collapse;
    }

    th {
        font-weight: normal;
        font-size: 12px;
        border-bottom: 1px solid #CCC;
        border-top: 1px solid #CCC;
        border-left: 1px solid #CCC;
        border-right: 1px solid #CCC;
    }

    td {
        border: none;
        font-size: 12px;
    }

    td.bordered {
        border-bottom: 1px solid #CCC;
        border-top: 1px solid #CCC;
        border-left: 1px solid #CCC;
        border-right: 1px solid #CCC;
        font-size: 12px;
    }

</style>