<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Main extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('app_config_model');
		$this->load->model('master/operator_model');
	}
	
	public function index()
	{
		getMenuBoxed();
	}

	public function show_404()
	{
		echo "404 ";
	}

	public function saveUserData()
	{
		$saveconfig = array();
		$saveconfig['fidOperator'] = $this->session->userdata('idOperator');
		$saveconfig['key'] 		= $this->input->post('key');
		$saveconfig['value'] 	= $this->input->post('value');

		$res = $this->app_config_model->save($saveconfig);

		$savedata = array();
		$savedata[$this->input->post('key')] 	= $this->input->post('value');
		$this->session->set_userdata($savedata);
		$res = $this->session->userdata();
		$this->result['res'] = $res;
		$this->success('OK');
	}

	public function getDbConfig()
	{
		$this->app_config_model->set_where(array('fidOperator'=>$this->session->userdata('idOperator')));
		$res = $this->app_config_model->get_list();

		$this->result['res'] = $res->result_array();
		$this->success('OK');
	}

	public function getSkinConfig()
	{
		$user_name = $this->session->userdata('userName');
		if($user_name != 'andri')
		{
			return false;
		}
		$data = array(
			'content' => 'skin-config'
		);
		$this->load->view($data['content'],$data);
	}
	
	public function getComboDepartment()
	{
		$this->load->model('master/departement_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		$this->departement_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$list_combo = $this->departement_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['deptCode'].'">'.$row['deptName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboDeptListPrivilege()
	{
		$this->load->model('master/departement_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$dept_privilege = get_list_dept_privilege();
		$filter_dept = explode(',', trim($dept_privilege));
		$result_option = '';
		$where = array();
		$where['businessUnitCode'] = $business_unit_code;
		
		if ($dept_privilege) {
			$dept_list = '';
			foreach ($filter_dept as $key => $dpt) {
				if ($key != 0)
					$dept_list .= ',';
				$dept_list .= '\''.$dpt.'\'';
			}
			$where['deptCode in (' . $dept_list . ')'] = null;
		} 
		
		$this->departement_model->set_where($where);
		$list_combo = $this->departement_model->get_list();
	    // echo $this->db->last_query();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['deptCode'].'">'.$row['deptName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboAdvanceCategory()
	{
		$this->load->model('master/advance_category_model');
		$is_active = "1";
		$result_option = '';
		$this->advance_category_model->set_where(array('isActive'=>$is_active));
		$list_combo = $this->advance_category_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['idAdvanceCategory'].'">'.$row['advanceCategory'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboAdvanceRequest()
	{
		$this->load->model('master/advance_request_model');
		$is_active = "1";
		$result_option = '';
		$where = array();
		$where['tranStatus'] = 4;
		$this->advance_request_model->set_where($where);
		$list_combo = $this->advance_request_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['advReqNum'].'">'.$row['advReqNum']." - ".$row['description'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboAccount()
	{
		$this->load->model('master/account_model');
		//$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		//$this->account_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$list_combo = $this->account_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['accountCode'].'">'.
			$row['accountCode']." : ".$row['accountName'].'</option>';
		}
		
		echo $result_option;
	}
	
	public function getComboBusinessPartner()
	{
		$this->load->model('master/business_partner_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$role_code 			= $this->input->post('role_code');
		$result_option = '';
		$this->business_partner_model->set_where(array('businessUnitCode'=>$business_unit_code,'tbl.roleCode'=>$role_code));
		$this->business_partner_model->set_order(array('businessPartnerCode'=>'ASC'));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboBusinessPartnerInterco()
	{
		$this->load->model('master/business_partner_model');
		$where = array();
		$where['businessUnitCode'] = $this->input->post('business_unit_code');
		$where["(
			tbl.\"roleCode\" = 'A'
			OR tbl.\"roleCode\" = 'H'
			OR tbl.\"roleCode\" = 'K'
		)"] = NULL;

		$result_option = '';
		$this->business_partner_model->set_where($where);
		$this->business_partner_model->set_order(array('businessPartnerCode'=>'ASC'));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboWarehouse()
	{
		$this->load->model('master/warehouse_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		$this->warehouse_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$this->warehouse_model->set_order(array('warehouseCode'=>'ASC'));
		$list_combo = $this->warehouse_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['warehouseCode']
			.'" data-locationcode="'.getLocation($row['warehouseCode'],$business_unit_code).'" >'
			.$row['warehouseCode']." - ".$row['warehouseName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboItemCategory()
	{
		$this->load->model('master/item_category_model');
		$result_option = '';
		$this->item_category_model->set_order(array('itemCategory'=>'ASC'));
		$list_combo = $this->item_category_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['itemCategory'].'" >'
			.$row['itemCategory']." - ".$row['description'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboBusinessVendorInterco()
	{
		$this->load->model('master/business_partner_model');
		$where = array();
		$where['businessUnitCode'] = $this->input->post('business_unit_code');
		$where["(
			tbl.\"roleCode\" = 'C'
			OR tbl.\"roleCode\" = 'J'
		)"] = NULL;

		$result_option = '';
		$this->business_partner_model->set_where($where);
		$this->business_partner_model->set_order(array('businessPartnerCode'=>'ASC'));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboStoreBilling()
	{
		$this->load->model('master/business_partner_model');
		$where = array();
		$where['businessUnitCode'] = $this->input->post('business_unit_code');
		// $where['ParentCode']	   = $this->input->post('parent_code');
		$where["(
			tbl.\"roleCode\" = 'A'
			OR tbl.\"roleCode\" = 'D'
			OR tbl.\"roleCode\" = 'H'
		)"] = NULL;
		// $business_unit_code = $this->input->post('business_unit_code');
		// $role_code 			= $this->input->post('role_code');
		// $parent_code 		= $this->input->post('parent_code');
		$result_option = '';
		// $this->business_partner_model->set_where(array('businessUnitCode'=>$business_unit_code,'tbl.roleCode'=>$role_code,'tbl.ParentCode'=>$parent_code));
		$this->business_partner_model->set_where($where);
		$this->business_partner_model->set_order(array('businessPartnerCode'=>'ASC'));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}
	
	public function getComboStoreInv()
	{
		$this->load->model('master/business_partner_model');
		$where = array();
		$where['businessUnitCode'] = $this->input->post('business_unit_code');
		$where['ParentCode']	   = $this->input->post('parent_code');
		$where["(
			tbl.\"roleCode\" = 'A'
			OR tbl.\"roleCode\" = 'H'
		)"] = NULL;
		// $business_unit_code = $this->input->post('business_unit_code');
		// $role_code 			= $this->input->post('role_code');
		// $parent_code 		= $this->input->post('parent_code');
		$result_option = '';
		// $this->business_partner_model->set_where(array('businessUnitCode'=>$business_unit_code,'tbl.roleCode'=>$role_code,'tbl.ParentCode'=>$parent_code));
		$this->business_partner_model->set_where($where);
		$this->business_partner_model->set_order(array('businessPartnerCode'=>'ASC'));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}
	
	public function getComboRequestType()
	{
		$this->load->model('master/request_type_model');
		$result_option = '';
		$this->request_type_model->set_where(array('isActive'=>1));
		$list_combo = $this->request_type_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['idRequestType'].'">'.$row['requestType'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboCurrency()
	{
		$this->load->model('master/currency_model');
		$result_option = '';
		$list_combo = $this->currency_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= 
			'<option value="'.$row['currency']
			.'" data-currencyrate="'.getCurrencyRate($row['currency']).'" >'
			.$row['currency'].' - ('.$row['currencyName'].')</option>';
		}
		
		echo $result_option;
	}

	public function getComboRoleAs()
	{
		$this->load->model('master/business_partner_role_model');
		$result_option = '';
		$list_combo = $this->business_partner_role_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['roleCode'].'">'.$row['roleCode']." - ( ".$row['roleName']." )".'</option>';
		}
		
		echo $result_option;
	}

	public function getComboBusinessPartnerNoRole()
	{
		$this->load->model('master/business_partner_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		$this->business_partner_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboProject()
	{
		$this->load->model('master/project_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		$this->project_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$list_combo = $this->project_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['projectId'].'">'.$row['projectId']." - ".$row['projectName'].'</option>';
		}
		
		echo $result_option;
	}
	
	public function getComboProjectApproved()
	{
		$this->load->model('master/project_model');
		$business_unit_code = $this->input->post('business_unit_code')?:$this->session->userdata('businessUnitCode');
		$result_option = '';
		$this->project_model->set_where(array('businessUnitCode'=>$business_unit_code,' "tranStatus" >= 3'=>null));
		$list_combo = $this->project_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['projectId'].'">'.$row['projectId']." - ".$row['projectName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboStatusFilter()
	{
		$this->load->model('master/trans_status_model');
		$result_option = '';
		$this->trans_status_model->set_order(array('idTransStatus'=>'ASC'));
		$list_combo = $this->trans_status_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['idTransStatus'].'">'.$row['description'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboStatusInvoiceFilter()
	{
		$this->load->model('master/trans_status_invoice_model');
		$result_option = '';
		$where = 'idTransStatus in (1,2,3)';
		$this->trans_status_invoice_model->set_where($where);
		$this->trans_status_invoice_model->set_order(array('idTransStatus'=>'ASC'));
		$list_combo = $this->trans_status_invoice_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['idTransStatus'].'">'.$row['description'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboStatusInvoiceOS()
	{
		$this->load->model('master/trans_status_invoice_model');
		$result_option = '';
		$where = array();
		$where = 'idTransStatus = 0 OR idTransStatus = 9';
		$this->trans_status_invoice_model->set_where($where);
		$this->trans_status_invoice_model->set_order(array('idTransStatus'=>'ASC'));
		$list_combo = $this->trans_status_invoice_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['idTransStatus'].'">'.$row['description'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboBankCashAccount()
	{
		$this->load->model('master/bank_cash_account_model');
		$business_unit_code = $this->input->post('business_unit_code')?:$this->session->userdata('businessUnitCode');
		$result_option = '';
		$this->bank_cash_account_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$list_combo = $this->bank_cash_account_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['bankAccountCode'].'">'.$row['bankAccountCode']." (".$row['bankAccountName'].")".'</option>';
		}
		
		echo $result_option;
	}

	public function getComboAllBusinessPartner()
	{
		$this->load->model('master/business_partner_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		$this->business_partner_model->set_where(array('businessUnitCode'=>$business_unit_code));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboAllBusinessPartnerByRole()
	{
		$this->load->model('master/business_partner_model');
		$business_unit_code = $this->input->post('business_unit_code');
		$result_option = '';
		$this->business_partner_model->set_where(array('businessUnitCode'=>$business_unit_code, 'roleCode' => 'A'));
		$list_combo = $this->business_partner_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['businessPartnerCode'].'">'.$row['businessPartnerCode']." - ".$row['businessPartnerName'].'</option>';
		}
		
		echo $result_option;
	}

	public function getComboStatusBankReconsile()
	{
		$this->load->model('master/bank_reconsile_status_model');
		$result_option = '';
		$this->bank_reconsile_status_model->set_order(array('idTransStatus'=>'ASC'));
		$list_combo = $this->bank_reconsile_status_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['idTransStatus'].'">'.$row['description'].'</option>';
		}
		
		echo $result_option;
	}
}