<div class="row">
	<div class="col-lg-12">
			<form method="get" class="form-horizontal">
				<div class="hr-line-dashed"></div>
				<div class="form-group">
					<div class="col-sm-4 col-sm-offset-2">
						<button class="btn btn-primary" type="button" onclick="updateSeason()"><i class="fa fa-plus"></i> Add new Season</button>
					</div>
				</div>
			</form>
	</div>
	<div class="col-sm-12">
		<div class="table-responsive " style="width:100%">
			<table id="listDataTableCrudSeason" class="table table-striped table-bordered table-hover" style="width:100%;">
				<thead>
					<tr>
						<th>No</th>
						<th>ID Season</th>
						<th>Description</th>
						<th>From Date</th>
						<th>To Date</th>
						<th>*</th>
					</tr>
				</thead>
			</table>
		</div>
	</div>
</div>
<script>
	$(document).ready(function() {
		var listDataTableCrudSeason = $('#listDataTableCrudSeason')
			.on('preXhr.dt', function(e, settings, data) {
				$('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "main/modal/crudSeasonListPage",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.id_item_group = $('#id_item_group').val(),
							d.id_category = $('#id_category').val()
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						$('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [{
						render: function(data, type, row, meta) {
							return meta.row + meta.settings._iDisplayStart + 1;
						},
						"targets": 0,
						"orderable": false
					},
					{
						render: function(data, type, row) {
							return `<button class="btn btn-primary btn-xs" onClick="updateSeason(1,'${row['IdSeason']}','${row['Description']}','${row['FromDate']?row['FromDate']:''}','${row['ToDate']?row['ToDate']:''}')"><i class="fa fa-pencil"></i></button>`;
						},
						"targets": 5,
						"orderable": false
					},
				],
				'columns': [{
						defaultContent: ''
					},
					{
						data: 'IdSeason'
					},
					{
						data: 'Description'
					},
					{
						data: 'FromDate'
					},
					{
						data: 'ToDate'
					},
					{
						defaultContent: ''
					}
				],
				order: [
					[1, 'asc']
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					$('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
				},
				buttons: [{
					extend: 'copy',
					exportOptions: {
						orthogonal: 'export'
					}
				}, ],
			});
	})
	async function updateSeason(action_type=0, id_season = '', text = '', from_date='', to_date = '') {
		let	title = 'Add Season';
		let readonly = '';
		let disable_style = '';
		if (action_type==1)
		{
			title = 'Update Season ' + id_season
			readonly = 'readonly';
			disable_style = 'style="background-color: #a9a9a936;"';
		}
		var {
			value: formValues
		} = await Swal.fire({
			title: title,
			html: '<form id="form-input-season" autocomplete="off">' +
			'<hr style="margin-top: 0px;margin-bottom: 10px;><div class="form-group"><label class="font-normal" style="margin-bottom:0px">ID Season</label> '+
      '<input id="swal-input1" value="' + id_season + '" name="id_season" class="swal2-input" placeholder="ID Season" data-mask="999" '+readonly+' '+ disable_style+'></div>' +
			'<div class="form-group" style="margin-bottom:0px"><label class="font-normal" style="margin-bottom:0px">Season Description</label>'+
			'<input id="swal-input2" value="' + text + '" name="season_description" class="swal2-input" placeholder="Season Description"></div>' +
			'<div class="form-group" style="margin-bottom:0px"><label class="font-normal" style="margin-bottom:10px">Season Date</label>'+
			'<div class="input-daterange input-group" id="datepicker">' +
			'	<input id="from_date" type="text" class="input-sm form-control" name="from_date" value="' +from_date+ '" data-mask="9999-99-99" placeholder="YYYY-MM-DD">' +
			'	<span class="input-group-addon">to</span>' +
			'	<input id="to_date" type="text" class="input-sm form-control" name="to_date" value="' +to_date+ '" data-mask="9999-99-99" placeholder="YYYY-MM-DD">' +
			'</div></div>' +
			'<input hidden id="swal-input9" value="' + action_type + '" name="action_type" class="swal2-input">' +
				'</form>',
			focusConfirm: false,
			didRender: ()=> {
			},
			preConfirm: () => {
				if (!$('#swal-input1').val()) {
					Swal.showValidationMessage('ID Season belum di isi!');
					$('#swal-input1').focus();
				}
				if (!$('#swal-input2').val()) {
					Swal.showValidationMessage('Season Description belum di isi!');
					$('#swal-input2').focus();
				}
				return $('#form-input-season').serialize()
			}
		})

		if (formValues) {
			$.ajax({
				type: 'POST',
				url: site_url + "main/modal/saveCrudSeason/",
				dataType: 'json',
				data: formValues,
				success: function(response) {
					swal.fire(response['header'] || 'success', response['message'] || '', "success").then(() => {
						refreshDataCrudSeason();
					});
				},
				error: function(jqXhr, textStatus, errorThrown) {
					var error_message = 'internal error';
					if (jqXhr.responseJSON !== undefined) {
						error_message = jqXhr['responseJSON']['message'];
					}
					swal.fire('error', error_message, "error");
				}
			});
		}
	}

	function refreshDataCrudSeason(reload_paging = false) {
		$('#listDataTableCrudSeason').DataTable().ajax.reload(null, reload_paging);
	}
</script>