<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<div class="filter-content" style="">
						<form autocomplete="off" method="post" id="form_input" class="form-horizontal">
							<div class="row">
								<div class="col-sm-8">
                                    <br>
                                    <div class="form-group">
                                        <label class="col-sm-2">Kendaraan</label>
                                        <div class=" input-group col-sm-4">
                                            <input type="text" class="form-control" id="vehicle_id" name="t_vehicle_id" value="" onkeydown="if(event.keyCode==13)getVehicleData();" placeholder="">
                                            <span class="help-block m-b-none"><i style="color:red;">* tekan enter setelah mengisi</i></span>  
                                        </div>
                                    </div><br>
                                    <div class="form-group">
                                        <label class="col-sm-2">Nomor Polisi</label>
                                        <div class=" input-group col-sm-3">
                                            <input type="text" class="form-control" id="vehicle_number" name="t_vehicle_number" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Berat Muatan (Std)</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" style="text-align:right;" id="default_weight" name="t_default_weight" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Tanggal</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" id="hauling_out_date" name="t_hauling_out_date" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Jam</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" id="hauling_out_time" name="t_hauling_out_time" value="" readonly>
                                        </div>
                                    </div>
								</div>
							</div>

						</form>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="row">
						<div class="col-lg-6">
                            <div class="row">
                                <div class="col-sm-3"></div>
								<div class="col-sm-2">
									<button class="btn btn-primary btn-sm btn-block saveBtn pull-left" type="submit"><i class="fa fa-save"></i> Save</button>
								</div>
								<div class="col-sm-2">
									<button class="btn btn-danger btn-sm btn-block backBtn pull-right" type="submit"><i class="fa fa-arrow-circle-left"></i> Cancel</button>
								</div>
							</div>
						</div>
					</div>
					
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function() {
        clearData();

        saveBtn.click(function() {
			let btn = $(this);
			startLoadingButton(btn);
			swal.fire({
				title: "Apakah data sudah benar ?",
				text: "Data akan disimpan",
				icon: "info",
				showCancelButton: true,
				confirmButtonText: 'Simpan',
                cancelButtonText:'Tidak',
			}).then(isConfirm => {
				if (isConfirm.value) {
				    var form_data = $('#form_input').serialize(); 				
					$.ajax({
						type: "POST",
						url: site_url + "hauling/hauling_outbound/save",
						data: form_data, 
						dataType: 'json',
						success: function(response) {
							swal.fire(response['header'] || 'success', response['message'] || '', "success").then(() => {
								// window.location = site_url + "coalgetting_outbound/" + response['id'];
								stopLoadingButton(btn);
                                clearData();
							});
						},
						error: function(jqXhr, textStatus, errorThrown) {
							var error_message = 'internal error';
							if (jqXhr.responseJSON !== undefined) {
								error_message = jqXhr['responseJSON']['message'];
							}
							swal.fire('error', error_message, "error");
							stopLoadingButton(btn);
						}
					});
				} else {
					stopLoadingButton(btn);
					return false;
				}
			});
		});


        backBtn.click(function() {
            swal.fire({
				title: "Apakah input data akan dibatalkan ?",
				text: "",
				icon: "warning",
				showCancelButton: true,
				confirmButtonText: 'Ya',
                cancelButtonText:'Tidak',
			}).then(isConfirm => {
                if (isConfirm.value) {
                    clearData();
                }
            });            
		});

	});


    function getVehicleData() {
		$.ajax({
			type: "POST",
			url: site_url + "vehicle/data_vehicle",
			data: {
				vehicle_id: $('#vehicle_id').val()
			},
			dataType: 'json',
			success: function (response) {
				$('#vehicle_number').val(response.vehicle.vehicle_number);
				$('#default_weight').val(response.vehicle.default_weight);
				$('#hauling_out_date').val(format_date(response.tgl));
				$('#hauling_out_time').val(response.jam);
			},
			error: function (jqXhr, textStatus, errorThrown) {
				var error_message = 'Data Tidak Ditemukan';
				if (jqXhr.responseJSON !== undefined) {
					error_message = jqXhr['responseJSON']['message'];
				}
                swal.fire('warning', error_message, "warning");
			}
		});
	}

    function clearData(){
        $('#vehicle_id').val('');
        $('#vehicle_number').val('');
        $('#default_weight').val('0');
        $('#hauling_out_date').val('');
        $('#hauling_out_time').val('');
    }

    

</script>