<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox">
				<?= form_header('6') ?>
				<div class="ibox-content">
					<div class="clients-list">

						<div class="table-responsive ">
							<table id="clientDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
								<thead>
									<tr>
										<th>Name</th>
										<th>Address</th>
										<th>Email</th>
										<th>Phone</th>
										<th>Status</th>
										<th>Role As</th>
									</tr>
								</thead>
							</table>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		$('#clientDataTable').DataTable({
			'processing': true,
			'serverSide': true,
			'serverMethod': 'post',
			'ajax': {
				'url': site_url + "master/business_partner/listPage",
				'data': function(d) {}
			},
			"columnDefs": [{
					"render": function(data, type, row) {
						return getViewButton(row['businessPartnerCode'], row['businessUnitCode'], row['businessPartnerName']);
					},
					"targets": 0,
					"orderable": true
				},
				{
					"render": function(data, type, row) {
						var res;
						if (row['status'] == '0') {
							res = '<a class="btn btn-danger btn-xs btn-rounded" href="#"><i class="fa fa-times-rectangle-o"></i>&nbsp; inActive </a>';
						} else {
							res = '<a class="btn btn-primary btn-xs btn-rounded" href="#"><i class="fa fa-check-square-o"></i>&nbsp; Active </a>';
						}
						return res;
					},
					"targets": 4,
					"orderable": true
				}
			],
			'columns': [{
					data: 'businessPartnerCode'
				},
				{
					data: 'address'
				},
				{
					data: 'email'
				},
				{
					data: 'phone'
				},
				{
					data: 'status'
				},
				{
					data: 'roleName'
				}
			],
			initComplete: function() {},
		});

	});

	function getViewButton(trans_id, business_unit, name) {
		return '<a data-style="zoom-in" type="button" class="btn btn_modules_10 btn-xs loadingButton" href="<?= base_url(uri_string()) ?>/input/' + encode(trans_id) + '/' + encode(business_unit) + '">' + trans_id + ' - ' + name + '</a>'
	}

	function refreshDataTable() {
		$('#clientDataTable').DataTable().ajax.reload(null, false);
	}
</script>