<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins ">
				<?= form_header('6') ?>
				<div class="ibox-content">
					<div class="table-responsive ">
						<table id="userDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
							<thead>
								<tr>
									<th>Username</th>
									<th>Name</th>
									<th>Email</th>
									<th>Phone</th>
									<th>Expiry date</th>
									<th><i class="fa fa-asterisk"></i></th>
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function() {
		$('#userDataTable').DataTable({
			'processing': true,
			'serverSide': true,
			'serverMethod': 'post',
			'ajax': {
				'url': site_url + "settings/user/listPage",
				'data': function(d) {}
			},
			"columnDefs": [{
				"render": function(data, type, row) {
					var res =
						'<div class="btn-group">' +
						'<button data-toggle="dropdown" class="btn btn-default btn-xs dropdown-toggle">Action <span class="caret"></span></button>' +
						'<ul class="dropdown-menu">' +
						'<li><a href="' + site_url + 'settings/user/input/' + row['idOperator'] + '">Edit</a></li>' +
						'<li class="divider"></li>' +
						'<li><a data-id="'+row['idOperator']+'" data-username="'+row['userName']+'" class="delete-user-btn" href="javascript:void(0)">Delete</a></li>' +
						'</ul>' +
						'</div>';
					return res;
				},
				"targets": 5,
				"orderable": false
			}],
			'columns': [{
					data: 'userName'
				},
				{
					data: 'name'
				},
				{
					data: 'email'
				},
				{
					data: 'phone'
				},
				{
					data: 'expiryDate'
				},
				{
					defaultContent: ''
				},
			],
			initComplete: function() {
			$('.delete-user-btn').on('click', function() {
				let idOperator = $(this).data('id'); 
				let username = $(this).data('username'); 
				swal.fire({
					title: "Hapus user "+username+"?",
					text: "Pengguna akan dihapus",
					icon: "warning",
					showCancelButton: true,
					confirmButtonText: 'Submit',
				}).then(isConfirm => {
					if (isConfirm.value) {
						$.ajax({
							type: "POST",
							url: site_url + "settings/user/deleteUser",
							data: {
								idOperator: idOperator,
							},
							dataType: 'json',
							success: function(response) {
								swal.fire(response['header'] || 'success', response['message'] || '', "success").then(() => {
									refreshDataTable();
								});
							},
							error: function(jqXhr, textStatus, errorThrown) {
								var error_message = 'internal error';
								if (jqXhr.responseJSON !== undefined) {
									error_message = jqXhr['responseJSON']['message'];
								}
								swal.fire('error', error_message, "error");
							}
						});
					} else {
						return false;
					}
				});
			});},
			drawCallback: function(settings) {
				$('.row-elipsis').ellipsis().tooltip();
			},
		});

	});

	function deleteUser(id) {
		var id = 0;
	}

	function refreshDataTable() {
		$('#userDataTable').DataTable().ajax.reload(null, false);
	}
</script>