<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>mine-Seal | Forgot password</title>

    <link href="<?= base_url() ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= base_url() ?>assets/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="<?= base_url() ?>assets/css/animate.css" rel="stylesheet">
    <link href="<?= base_url() ?>assets/css/style.css" rel="stylesheet">

	<!-- Ladda style -->
	<link href="<?= base_url() ?>assets/css/plugins/ladda/ladda-themeless.min.css" rel="stylesheet">
	<!-- Sweet Alert -->
	<link href="<?= base_url() ?>assets/css/plugins/sweetalert/sweetalert.css" rel="stylesheet">
	<link href="<?= base_url() ?>assets/css/plugins/iCheck/custom.css" rel="stylesheet">
</head>

<body class="gray-bg">

    <div class="passwordBox animated fadeInDown">
        <div class="row">

            <div class="col-md-12">
                <div class="ibox-content">

                    <h2 class="font-bold">Forgot password</h2>

                    <p>
                        Enter your email address and your password will be reset and emailed to you.
                    </p>

                    <div class="row">

                        <div class="col-lg-12">
                            <form class="m-t" role="form" id="forgotPasswordForm">
                                <div class="form-group">
                                    <input type="email" class="form-control" id="email" name="tEmail" placeholder="Email address" required="">
                                </div>

                                <button type="button" class="btn btn-primary block full-width m-b" id="resetButton" onClick="resetPassword()">Reset password</button>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <hr/>
        <div class="row">
            <div class="col-md-6">
                <p class="m-t"> <small>Copyright&copy; <?= date('Y') ?></small> </p>
            </div>
        </div>
    </div>
    
	<!-- Mainly scripts -->
	<script src="<?= base_url() ?>assets/js/jquery-3.1.1.min.js"></script>
	<script src="<?= base_url() ?>assets/js/bootstrap.js"></script>
    <!-- Ladda -->
    <script src="<?= base_url() ?>assets/js/plugins/ladda/spin.min.js"></script>
	<script src="<?= base_url() ?>assets/js/plugins/ladda/ladda.min.js"></script>
	<script src="<?= base_url() ?>assets/js/plugins/ladda/ladda.jquery.min.js"></script>

	<!-- Sweet alert -->
	<script src="<?= base_url() ?>assets/js/plugins/sweetalert/sweetalert.min.js"></script>
</body>

</html>

<script type="text/javascript">
	$(document).ready(function() {
		// $('#forgotPasswordForm').submit(function(e) {
		// 	e.preventDefault();
		// 	resetPassword(e);
		// });
		$('#email').focus();
	});

	function resetPassword(e) {
		var l = $('#resetButton').ladda();
		l.ladda('start');
		$.ajax({
			type: "POST",
			url: "<?= base_url('login/forgot/submit')?>",
			data: $("#forgotPasswordForm").serialize(),
			dataType: 'json',
			success: function(response) {
                console.log(response);
				if (response['error_msg']) {
					swal(response['header'] || 'error', response['error_msg'] || '', "error");
					l.ladda('stop');
				} else {
                    // alert('berhasil');
					window.location = "<?= base_url('login/forgot/info/')?>" + response['userLogin'];
				}
			},
			error: function(jqXhr, textStatus, errorThrown) {
				// console.log((textStatus));
				l.ladda('stop');
				swal('error', 'please reload the page', "error");
			}
		});
	}
</script>