<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Coalgetting_dashboard extends MY_Controller
{

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('coalgetting/coal_getting_inbound_model');
		$this->bc->set_title('Coal Getting Dashboard');
		$this->bc->add('Dashboard', base_url() . 'dashboard');
		$this->bc->add('Coal Getting', base_url() . 'coalgetting_dashboard');
	}

	public function index()
	{
		$data = array(
			'content' => 'coalgetting_dashboard/main'
		);
		$this->load->view('tpl', $data);
	}

	public function show_404()
	{
		echo "404 ";
	}
	
	public function load_chart_day()
	{
		$date_start = validate_input($this->input->post('t_filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['coal_get_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['coal_get_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		$group_by = array();
		$group_by[] = 'cg_day';
		$this->coal_getting_inbound_model->set_order(array('cg_day'=>'ASC'));
		$this->coal_getting_inbound_model->set_where($where);
		$this->coal_getting_inbound_model->set_group($group_by);
		$list_data = $this->coal_getting_inbound_model->get_list_byday();

		$line_chart_data = array(
			'totalWeight' => '',
			'transDate' => ''
		);

		foreach($list_data->result_array() as $dat)
		{
			$line_chart_data['totalWeight'] .= $dat['total'].',';
			$line_chart_data['transDate'] .= "'" . $dat['cg_day'] . "',";
		}	

		$data = array(
			'content' => 'coalgetting_dashboard/chart_day',
			'line_chart_data' => $line_chart_data
		);
		$this->load->view($data['content'], $data);
	}

	public function load_chart_month()
	{
		$date_start = validate_input($this->input->post('t_filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['coal_get_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['coal_get_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		$group_by = array();
		$group_by[] = 'cg_month';
		$group_by[] = 'cg_month_name';
		$this->coal_getting_inbound_model->set_order(array('cg_month'=>'ASC'));
		$this->coal_getting_inbound_model->set_where($where);
		$this->coal_getting_inbound_model->set_group($group_by);
		$list_data = $this->coal_getting_inbound_model->get_list_bymonth();

		$line_chart_data = array(
			'totalWeight' => '',
			'transDate' => ''
		);

		foreach($list_data->result_array() as $dat)
		{
			$line_chart_data['totalWeight'] .= $dat['total'].',';
			$line_chart_data['transDate'] .= "'" . $dat['cg_month_name'] . "',";
		}	

		$data = array(
			'content' => 'coalgetting_dashboard/chart_month',
			'line_chart_data' => $line_chart_data
		);
		$this->load->view($data['content'], $data);
	}

	public function load_summary()
	{
		$date_start = validate_input($this->input->post('t_filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['coal_get_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['coal_get_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		$tgl1 = new DateTime($filter_date_start);
		$tgl2 = new DateTime($filter_date_end);
		$days = $tgl2->diff($tgl1)->days + 1;
		$dayshour = ($days * 24) ;

		$this->coal_getting_inbound_model->set_where($where);
		$totalcg = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totalhr = ( $totalcg / $dayshour );

		$data = array(
			'content' => 'coalgetting_dashboard/summary',
			'totalcg' => $totalcg,
			'totalhr' => $totalhr,		);
		$this->load->view($data['content'], $data);
	}

	public function load_table()
	{
		$currentdate = date('Y-m-d');
		$where_current = array();
		$where_current['coal_get_date = ' . quotedStr($currentdate) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_current);
		$totalcurrent = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totalcurrenthour = ($totalcurrent / 24) ; 

		$yesterday = date('Y-m-d', strtotime($currentdate. ' - 1 days'));
		$where_yesterday = array();
		$where_yesterday['coal_get_date = ' . quotedStr($yesterday) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_yesterday);
		$totalyesterday = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totalyesterdayhour = ($totalyesterday / 24);

		if($totalyesterday !=0){
			$growthday = (($totalcurrent - $totalyesterday)/ $totalyesterday)*100;
		}else{
			$growthday = 100;
		}
		if($totalyesterdayhour !=0){
			$growthdayhour = (($totalcurrenthour - $totalyesterdayhour)/ $totalyesterdayhour)*100;
		}else{
			$growthdayhour = 100;
		}

		// -------------------------------------------

		$weekend = date('Y-m-d');
		$weekstart = date('Y-m-d', strtotime($weekend. ' - 7 days'));
		$where_currentweek = array();
		$where_currentweek['coal_get_date >= ' . quotedStr($weekstart) . ''] = null;
		$where_currentweek['coal_get_date <= ' . quotedStr($weekend) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_currentweek);
		$totalcurrentweek = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totalcurrentweekhour = ($totalcurrentweek / (24 * 7)) ; 

		$lastweekstart =  date('Y-m-d', strtotime($weekstart. ' - 8 days'));
		$lastweeksend =  date('Y-m-d', strtotime($weekstart. ' - 1 days'));
		$where_lastweek = array();
		$where_lastweek['coal_get_date >= ' . quotedStr($lastweekstart) . ''] = null;
		$where_lastweek['coal_get_date <= ' . quotedStr($lastweeksend) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_lastweek);
		$totallastweek = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totallastweekhour = ($totallastweek / (24 * 7)) ; 

		if($totallastweek != 0){
			$growthweek = (($totalcurrentweek - $totallastweek)/ $totallastweek)*100;
		}else{
			// $growthweek = (($totalcurrentweek - $totallastweek)/ 1)*100;
			$growthweek = 100;
		}
		if($totallastweekhour != 0){
			$growthweekhour = (($totalcurrentweekhour - $totallastweekhour)/ $totallastweekhour)*100;
		}else{
			// $growthweekhour = (($totalcurrentweekhour - $totallastweekhour)/ 1)*100;
			$growthweekhour = 100;
		}

		// -------------------------------------------


		$monthend = date('Y-m-d');
		$monthstart = date('Y-m-d', strtotime($monthend. ' - 30 days'));
		$where_currentmonth = array();
		$where_currentmonth['coal_get_date >= ' . quotedStr($monthstart) . ''] = null;
		$where_currentmonth['coal_get_date <= ' . quotedStr($monthend) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_currentmonth);
		$totalcurrentmonth = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totalcurrentmonthhour = ($totalcurrentmonth / (24 * 31)) ; 

		$lastmonthstart = date('Y-m-d', strtotime($monthstart. ' - 31 days'));
		$lastmonthend =  date('Y-m-d', strtotime($monthstart. ' - 1 days'));
		$where_lastmonth = array();
		$where_lastmonth['coal_get_date >= ' . quotedStr($lastmonthstart) . ''] = null;
		$where_lastmonth['coal_get_date <= ' . quotedStr($lastmonthend) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_lastmonth);
		$totallastmonth = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totallastmonthhour = ($totallastmonth / (24 * 31)) ; 

		if($totallastmonth != 0){
			$growthmonth = (($totalcurrentmonth - $totallastmonth)/ $totallastmonth)*100;
		}else{
			$growthmonth = 100;
		}
		if($totallastmonthhour != 0){
			$growthmonthhour = (($totalcurrentmonthhour - $totallastmonthhour)/ $totallastmonthhour)*100;
		}else{
			$growthmonthhour = 100;
		}

		// -------------------------------------------

		$yearend = date('Y-m-d');
		$yearstart = date('Y-m-d', strtotime($yearend. ' - 365 days'));
		$where_currentyear = array();
		$where_currentyear['coal_get_date >= ' . quotedStr($yearstart) . ''] = null;
		$where_currentyear['coal_get_date <= ' . quotedStr($yearend) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_currentyear);
		$totalcurrentyear = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totalcurrentyearhour = ($totalcurrentyear / (24 * 365)) ; 

		$lastyearstart = date('Y-m-d', strtotime($yearstart. ' - 366 days'));
		$lastyearend =  date('Y-m-d', strtotime($yearstart. ' - 1 days'));
		$where_lastyear = array();
		$where_lastyear['coal_get_date >= ' . quotedStr($lastyearstart) . ''] = null;
		$where_lastyear['coal_get_date <= ' . quotedStr($lastyearend) . ''] = null;
		$this->coal_getting_inbound_model->set_where($where_lastyear);
		$totallastyear = $this->coal_getting_inbound_model->getTotalCoalgetting();
		$totallastyearhour = ($totallastyear / (24 * 365)) ; 

		if($totallastyear != 0){
			$growthyear = (($totalcurrentyear - $totallastyear)/ $totallastyear)*100;
		}else{
			$growthyear = 100;
		}
		if($totallastyearhour != 0){
			$growthyearhour = (($totalcurrentyearhour - $totallastyearhour)/ $totallastyearhour)*100;
		}else{
			$growthyearhour = 100;
		}

		// -------------------------------------------
		
		$data = array(
			'content' => 'coalgetting_dashboard/table',
			'totalcurrent' => $totalcurrent,
			'totalyesterday' => $totalyesterday,
			'growthday' => $growthday,
			'totalcurrenthour' => $totalcurrenthour,
			'totalyesterdayhour' => $totalyesterdayhour,
			'growthdayhour' => $growthdayhour,
			'totalcurrentweek' => $totalcurrentweek,
			'totallastweek' => $totallastweek,
			'growthweek' => $growthweek,
			'totalcurrentweekhour' => $totalcurrentweekhour,
			'totallastweekhour' => $totallastweekhour, 
			'growthweekhour' => $growthweekhour,
			'totalcurrentmonth' => $totalcurrentmonth,
			'totalcurrentmonthhour' => $totalcurrentmonthhour,
			'growthmonth' => $growthmonth,
			'totallastmonth' => $totallastmonth,
			'totallastmonthhour' => $totallastmonthhour,
			'growthmonthhour' => $growthmonthhour,
			'totalcurrentyear' => $totalcurrentyear,
			'totalcurrentyearhour' => $totalcurrentyearhour,
			'growthyear' => $growthyear,
			'totallastyear' => $totallastyear,
			'totallastyearhour' => $totallastyearhour,
			'growthyearhour' => $growthyearhour
		);
		$this->load->view($data['content'], $data);
	}

}