<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<div class="filter-content" style="">
						<form autocomplete="off" method="post" id="form_input" class="form-horizontal">
							<div class="row">
								<div class="col-sm-8">
                                    <br>
                                    <div class="form-group">
                                        <label class="col-sm-2">Nomor</label>
                                        <div class=" input-group col-sm-4">
                                            <input type="text" class="form-control" id="mining_number" name="t_mining_number" value="" placeholder="" onkeydown="if(event.keyCode==13)getDataMining();">
                                            <span class="help-block m-b-none"><i style="color:red;">* kosongkan nomor / input nomor yang ada untuk mencetak</i></span>                                            
                                        </div>
                                    </div><br>
                                    <div class="form-group">
                                        <label class="col-sm-2">Kendaraan</label>
                                        <div class=" input-group col-sm-3">
                                            <input type="text" class="form-control" id="vehicle_id" name="t_vehicle_id" value="" placeholder="" onkeydown="if(event.keyCode==13)getDataVehicle();">
                                            <span class="help-block m-b-none"><i style="color:red;">* tekan enter setelah mengisi</i></span> 
                                            <input type="text" class="form-control hidden" id="id_rec" name="t_id_rec" value="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Stock Room</label>
                                        <div class=" input-group col-sm-4">
                                            <input type="text" class="form-control" id="stockroom_id" name="t_stockroom_id" value="" >
                                            <!-- <input type="text" class="form-control" id="stockroom_id" name="t_stockroom_id" value="" onkeydown="if(event.keyCode==13)getDataStokRoom();"> -->
                                            <!-- <span class="help-block m-b-none"><i style="color:red;">* tekan enter setelah mengisi</i></span>  -->
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Vendor Card</label>
                                        <div class=" input-group col-sm-4">
                                            <input type="text" class="form-control" id="vendor_id" name="t_vendor_id" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group" hidden>
                                        <label class="col-sm-2">Vendor MIS</label>
                                        <div class=" input-group col-sm-4">
                                            <input type="text" class="form-control" id="vendor_mis" name="t_vendor_mis" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2"></label>
                                        <div class=" input-group col-sm-4">
                                            <input type="text" class=""style="border: none;background: none;" id="vendor_name" name="t_vendor_name" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Berat (Gross)</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" style="text-align:right;" id="gross_weight" name="t_gross_weight" value="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Berat Kosong</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" style="text-align:right;" id="tare_weight" name="t_tare_weight" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Berat (Nett)</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" style="text-align:right;" id="net_weight" name="t_net_weight" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Nomor Polisi</label>
                                        <div class=" input-group col-sm-3">
                                            <input type="text" class="form-control" id="vehicle_number" name="t_vehicle_number" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Tanggal</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" id="mining_date" name="mining_date" value="" readonly>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2">Jam</label>
                                        <div class=" input-group col-sm-2">
                                            <input type="text" class="form-control" id="mining_time" name="mining_time" value="" readonly>
                                        </div>
                                    </div>
								</div>
							</div>

						</form>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="row">
						<div class="col-lg-6">
                            <div class="row">
                                <div class="col-sm-2"></div>
                                <div class="col-sm-2">
                                    <button class="btn btn-info btn-sm btn-block" type="button" onClick="printData();" id="printBtn"><i class="fa fa-print"></i> Print</button>
                                </div>
								<div class="col-sm-2">
									<button class="btn btn-primary btn-sm btn-block saveBtn pull-left" type="submit"><i class="fa fa-save"></i> Save</button>
								</div>
								<div class="col-sm-2">
									<button class="btn btn-danger btn-sm btn-block backBtn pull-right" type="submit"><i class="fa fa-arrow-circle-left"></i> Clear</button>
								</div>
							</div>
						</div>
					</div>
					
				</div>
			</div>
		</div>
	</div>
</div>

<div style="display:none">
	<div id="print-content"></div>
</div>

<script>
	$(document).ready(function() {
        clearData();

        $("#gross_weight").keyup(function(){
			netweight( parseFloat(eval($("#gross_weight").val().replace(/,/g, ""))), parseFloat(eval($("#tare_weight").val().replace(/,/g, ""))) )
		});

        $("#tare_weight").keyup(function(){
			netweight( parseFloat(eval($("#gross_weight").val().replace(/,/g, ""))), parseFloat(eval($("#tare_weight").val().replace(/,/g, ""))) )
		});

		$("#mining_number").keyup(function(){
			let number = $('#mining_number').val();
			if (number != ''){
				document.getElementById("printBtn").disabled = false;
			} else {
				document.getElementById("printBtn").disabled = true;
			}
		});

        saveBtn.click(function() {
			let btn = $(this);
			startLoadingButton(btn);
			swal.fire({
				title: "Apakah data sudah benar ?",
				text: "Data akan disimpan",
				icon: "info",
				showCancelButton: true,
				confirmButtonText: 'Simpan',
                cancelButtonText:'Tidak',
			}).then(isConfirm => {
				if (isConfirm.value) {
				    var form_data = $('#form_input').serialize(); 				
					$.ajax({
						type: "POST",
						url: site_url + "hauling/stockroom_outbound/save",
						data: form_data, 
						dataType: 'json',
						success: function(response) {
							swal.fire(response['header'] || 'success', response['message'] || '', "success").then(() => {
								// window.location = site_url + "coalgetting_outbound/" + response['id'];
								stopLoadingButton(btn);
								$('#mining_number').val(response['vmin_number']);
								$('#mining_date').val(response['vmin_date']);
        						$('#mining_time').val(response['vmin_time']);
								document.getElementById("printBtn").disabled = false;
                                // clearData();
							});
						},
						error: function(jqXhr, textStatus, errorThrown) {
							var error_message = 'internal error';
							if (jqXhr.responseJSON !== undefined) {
								error_message = jqXhr['responseJSON']['message'];
								document.getElementById("printBtn").disabled = true;
							}
							swal.fire('error', error_message, "error");
							stopLoadingButton(btn);
						}
					});
				} else {
					stopLoadingButton(btn);
					return false;
				}
			});
		});

        backBtn.click(function() {
            swal.fire({
				title: "Input data akan dikosongkan ?",
				text: "",
				icon: "warning",
				showCancelButton: true,
				confirmButtonText: 'Ya',
                cancelButtonText:'Tidak',
			}).then(isConfirm => {
                if (isConfirm.value) {
                    clearData();
                }
            });            
		});

	});
    
    function getDataStokRoom() {
		$.ajax({
			type: "POST",
			url: site_url + "master/stockroom/get_stockroom",
			data: {
				stockroom_id: $('#stockroom_id').val()
			},
			dataType: 'json',
			success: function (response) {
				$('#vendor_id').val(response.vendor_id);
				// $('#vendor_name').val('   '+response.vendor_name);
				$('#vendor_mis').val(response.vendor_mis);
				$("#vendor_name").show();
			},
			error: function (jqXhr, textStatus, errorThrown) {
				var error_message = 'Data Tidak Ditemukan';
				if (jqXhr.responseJSON !== undefined) {
					error_message = jqXhr['responseJSON']['message'];
					// $("#vendor_name").hide();
				}
                swal.fire('warning', error_message, "warning");
			}
		});
	}

    function netweight(grossWeight, tareWeight)
	{
		var gross = grossWeight;
		var tare = tareWeight;
		var nett = grossWeight - tareWeight;

		$("#net_weight").val(number_format(nett,2));
	}

    function clearData(){
        $('#mining_number').val('');
        $('#vehicle_id').val('');
        $('#stockroom_id').val('');
        $('#vendor_id').val('');
        $('#vendor_mis').val('');
        $('#vendor_name').val('');
        $('#gross_weight').val('0');
        $('#tare_weight').val('0');
        $('#net_weight').val('0');
        $('#vehicle_number').val('');
        $('#mining_date').val('');
        $('#mining_time').val('');
        $('#id_rec').val('');
		document.getElementById("printBtn").disabled = true;
		$("#vendor_name").hide();
    }

    function getDataMining() {
		$.ajax({
			type: "POST",
			url: site_url + "hauling/stockroom_outbound/getMining",
			data: {
				mine_num: $('#mining_number').val()
			},
			dataType: 'json',
			success: function (response) {
				$('#mining_number').val(response.mining_data.mine_number);
				$('#vehicle_id').val(response.mining_data.vehicle_id);
				$('#stockroom_id').val(response.mining_data.stockroom_id);
				$('#vendor_id').val(response.mining_data.vendor_id);
				$('#vendor_mis').val(response.mining_data.vendor_mis);
				$('#vendor_name').val('   '+response.mining_data.vendor_name);
				$('#gross_weight').val(response.mining_data.gross_weight);
				$('#tare_weight').val(response.mining_data.tare_weight);
				$('#net_weight').val(response.mining_data.net_weight);
				$('#vehicle_number').val(response.mining_data.vehicle_number);
				$('#mining_date').val(format_date(response.mining_data.mine_date));
				$('#mining_time').val(response.mining_data.mine_time);
				$('#id_rec').val(response.mining_data.id_rec);
				$("#vendor_name").show();
			},
			error: function (jqXhr, textStatus, errorThrown) {
				var error_message = 'Data Tidak Ditemukan';
				if (jqXhr.responseJSON !== undefined) {
					error_message = jqXhr['responseJSON']['message'];
					$('#vehicle_id').val('');
					$('#stockroom_id').val('');
					$('#vendor_id').val('');
					$('#vendor_mis').val('');
					$('#gross_weight').val('0');
					$('#tare_weight').val('0');
					$('#net_weight').val('0');
					$('#vehicle_number').val('');
					$('#mining_date').val('');
					$('#mining_time').val('');
					$('#id_rec').val('');
					document.getElementById("printBtn").disabled = true;
					$("#vendor_name").hide();
				}
                swal.fire('warning', error_message, "warning");
			}
		});
	}

    function getDataVehicle() {
		$.ajax({
			type: "POST",
			url: site_url + "master/vehicle/get_vehicle",
			data: {
				vehicle_id: $('#vehicle_id').val()
			},
			dataType: 'json',
			success: function (response) {
				$('#vehicle_number').val(response.vehicle.vehicle_number);
				$('#tare_weight').val(response.vehicle.tare_weight);
				$('#vendor_id').val(response.vehicle.vendor_id);
				$('#vendor_name').val(response.vehicle.vendor_name);
				$("#vendor_name").show();
			},
			error: function (jqXhr, textStatus, errorThrown) {
				var error_message = 'Data Tidak Ditemukan';
				if (jqXhr.responseJSON !== undefined) {
					error_message = jqXhr['responseJSON']['message'];
					$("#vendor_name").hide();
				}
                swal.fire('warning', error_message, "warning");
			}
		});
	}

	function printData() {
        $.ajax({
            url: site_url + "hauling/stockroom_outbound/print_doc_pdf/",
            type: 'POST',
            dataType: 'html',
            data: { id : $('#mining_number').val() },
            success: function(result) {
            $('#print-content').html(result);
                    $('#print-content').printThis({
                        importCSS: false,
                        importStyle: false,
                        canvas: true,
                        copyTagClasses: false,    // copy classes from the html & body tag
                        loadCSS: ["<?=base_url()?>assets/css/cetak-packing.css"],
                    });    
            }
        });
    }

</script>
<script type="text/javascript" src="<?=base_url('assets/js/printThis.js')?>"></script>