<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Privilege extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('master/operator_model');
		$this->load->model('master/operator_access_model');
		$this->load->model('master/operator_type_model');
	}
	
	public function index()
	{
		 // echo "v".phpinfo();
		 $default_menu_url	= 'privilege/main';
		 $data = array(
		 	'content' => $default_menu_url
		 );
		 $this->load->view('tpl',$data);
	}

	public function listPage()
	{
		$draw = $this->input->post('draw')?:0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length')?:0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$isActive = $this->input->post('is_active');
		
		$where = array();
		
		$where["(
			tbl.\"description\" ~* '$searchValue'
		)"] = NULL;
		
		$this->operator_type_model->set_where($where);
		
		$list_count = $this->operator_type_model->count();
		$this->operator_type_model->set_limit($rowperpage);
		$this->operator_type_model->set_offset($start);
		$this->operator_type_model->set_order(array($columnName=>$columnSortOrder));
		$list_data  = $this->operator_type_model->get_list();
		
		$response = array(
		  "post" => $this->input->post(),
		  "draw" => intval($draw),
		  "iTotalRecords" => $list_count,
		  "iTotalDisplayRecords" => $list_count,
		  "aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function input($id=0)
	{
		if(!$id)
		{
			show_not_allowed();
		}
		$head = $this->operator_type_model->get($id);
		
		$sub_title = 'New Data';
		if($head['idOperatorType'])
		{
			$sub_title = 'Modify Data';
		}
		$data = array(
			'content' => 'privilege/input'
			,'head' => $head
			,'id' => $id
		);
		$this->bc->set_title('Privilege Input');
		$this->bc->set_title_nav($head['description']);
		$this->bc->set_sub_title($sub_title);
		$this->load->view('tpl',$data);
	}
	
	function save()
	{
		$idOperatorType = $this->input->post('idOperatorType');
		$selectedMenu = $this->input->post('selectedMenu');
		$selectedMenuParent = $this->input->post('selectedMenuParent');
		
		foreach($selectedMenuParent as $row)
		{
			foreach($row as $selectedMenuParentChild)
			{
				$str = str_replace('#','',$selectedMenuParentChild);
				if($str)
				$selectedMenu[] = $str;
			}
		}
		$selectedMenu = array_unique($selectedMenu);
		$operator_access = array();
		
		foreach($selectedMenu as $row)
		{
			$idMenu = substr($row, strpos($row, "_") + 1);
			$operator_access[] = array('fidOperatorType'=>$idOperatorType,'fidMenu'=>$idMenu);
		}
		
		$this->db->delete('msOperatorAccess', array('fidOperatorType' => $idOperatorType));
		// echo $this->db->last_query();
        $this->db->insert_batch('msOperatorAccess', $operator_access);
		
		$this->result['idOperatorType'] = $idOperatorType;
		
		$this->success('Save Success');
	}

}