<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Hauling_dashboard extends MY_Controller
{

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('hauling/hauling_model');
		$this->bc->set_title('Hauling Dashboard');
		$this->bc->add('Dashboard', base_url() . 'dashboard');
		$this->bc->add('Hauling', base_url() . 'hauling_dashboard');
	}

	public function index()
	{
		$data = array(
			'content' => 'hauling_dashboard/main'
		);
		$this->load->view('tpl', $data);
	}

	public function show_404()
	{
		echo "404 ";
	}

	public function load_summary()
	{
		$date_start = validate_input($this->input->post('t_filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['hauling_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['hauling_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		$tgl1 = new DateTime($filter_date_start);
		$tgl2 = new DateTime($filter_date_end);
		$days = $tgl2->diff($tgl1)->days + 1;
		$dayshour = ($days * 24) ;

		$this->hauling_model->set_where($where);
		$vhclcount = $this->hauling_model->count();
		$totalob = $this->hauling_model->getTotalHauling();
		$totalhr = ( $totalob / $dayshour );
		$vehiclehr = ($vhclcount / $dayshour);
		// echo $this->db->last_query(); die;

		$data = array(
			'content' => 'hauling_dashboard/summary',
			'totalob' => $totalob,
			'totalhr' => $totalhr,
			'vehclob' => $vhclcount,
			'vehclhr' => $vehiclehr
		);
		$this->load->view($data['content'], $data);
	}

	public function load_chart()
	{
		$chart_types = $this->input->post('t_ch_type')?:"day";

		$date_start = validate_input($this->input->post('t_filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['hauling_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['hauling_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($chart_types == "month"){
			$group_by = array();
			$group_by[] = 'ob_month';
			$group_by[] = 'ob_month_name';
			$this->hauling_model->set_order(array('ob_month'=>'ASC'));
			$this->hauling_model->set_where($where);
			$this->hauling_model->set_group($group_by);
			$list_data = $this->hauling_model->get_list_bymonth();

			$line_chart_data = array(
				'totalWeight' => '',
				'transDate' => ''
			);
	
			foreach($list_data->result_array() as $dat)
			{
				$line_chart_data['totalWeight'] .= $dat['total'].',';
				$line_chart_data['transDate'] .= "'" . $dat['ob_month_name'] . "',";
			}
		}	

		if ($chart_types == "day"){
			$group_by = array();
			$group_by[] = 'ob_day';
			$this->hauling_model->set_order(array('ob_day'=>'ASC'));
			$this->hauling_model->set_where($where);
			$this->hauling_model->set_group($group_by);
			$list_data = $this->hauling_model->get_list_byday();

			$line_chart_data = array(
				'totalWeight' => '',
				'transDate' => ''
			);
	
			foreach($list_data->result_array() as $dat)
			{
				$line_chart_data['totalWeight'] .= $dat['total'].',';
				$line_chart_data['transDate'] .= "'" . $dat['ob_day'] . "',";
			}
		}			

		if ($chart_types == "hour"){
			$group_by = array();
			$group_by[] = 'ob_hour';
			$this->hauling_model->set_order(array('ob_hour'=>'ASC'));
			$this->hauling_model->set_where($where);
			$this->hauling_model->set_group($group_by);
			$list_data = $this->hauling_model->get_list_byhour();

			$line_chart_data = array(
				'totalWeight' => '',
				'transDate' => ''
			);
	
			foreach($list_data->result_array() as $dat)
			{
				$line_chart_data['totalWeight'] .= $dat['total'].',';
				$line_chart_data['transDate'] .= "'" . $dat['ob_hour']. ":00" . "',";
			}
		}			

		$data = array(
			'content' => 'hauling_dashboard/chart',
			'charttypes' => $chart_types, 
			'line_chart_data' => $line_chart_data
		);
		$this->load->view($data['content'], $data);
	}

	public function load_table1()
	{
		$currentdate = date('Y-m-d');
		$where_current = array();
		$where_current['hauling_date = ' . quotedStr($currentdate) . ''] = null;
		$this->hauling_model->set_where($where_current);
		$totalcurrent = $this->hauling_model->getTotalHauling();
		$totalcurrenthour = ($totalcurrent / 24) ; 

		$yesterday = date('Y-m-d', strtotime($currentdate. ' - 1 days'));
		$where_yesterday = array();
		$where_yesterday['hauling_date = ' . quotedStr($yesterday) . ''] = null;
		$this->hauling_model->set_where($where_yesterday);
		$totalyesterday = $this->hauling_model->getTotalHauling();
		$totalyesterdayhour = ($totalyesterday / 24);

		if($totalyesterday !=0){
			$growthday = (($totalcurrent - $totalyesterday)/ $totalyesterday)*100;
		}else{
			$growthday = 100;
		}
		if($totalyesterdayhour !=0){
			$growthdayhour = (($totalcurrenthour - $totalyesterdayhour)/ $totalyesterdayhour)*100;
		}else{
			$growthdayhour = 100;
		}

		// -------------------------------------------

		$weekend = date('Y-m-d');
		$weekstart = date('Y-m-d', strtotime($weekend. ' - 7 days'));
		$where_currentweek = array();
		$where_currentweek['hauling_date >= ' . quotedStr($weekstart) . ''] = null;
		$where_currentweek['hauling_date <= ' . quotedStr($weekend) . ''] = null;
		$this->hauling_model->set_where($where_currentweek);
		$totalcurrentweek = $this->hauling_model->getTotalHauling();
		$totalcurrentweekhour = ($totalcurrentweek / (24 * 7)) ; 

		$lastweekstart =  date('Y-m-d', strtotime($weekstart. ' - 8 days'));
		$lastweeksend =  date('Y-m-d', strtotime($weekstart. ' - 1 days'));
		$where_lastweek = array();
		$where_lastweek['hauling_date >= ' . quotedStr($lastweekstart) . ''] = null;
		$where_lastweek['hauling_date <= ' . quotedStr($lastweeksend) . ''] = null;
		$this->hauling_model->set_where($where_lastweek);
		$totallastweek = $this->hauling_model->getTotalHauling();
		$totallastweekhour = ($totallastweek / (24 * 7)) ; 

		if($totallastweek != 0){
			$growthweek = (($totalcurrentweek - $totallastweek)/ $totallastweek)*100;
		}else{
			// $growthweek = (($totalcurrentweek - $totallastweek)/ 1)*100;
			$growthweek = 100;
		}
		if($totallastweekhour != 0){
			$growthweekhour = (($totalcurrentweekhour - $totallastweekhour)/ $totallastweekhour)*100;
		}else{
			// $growthweekhour = (($totalcurrentweekhour - $totallastweekhour)/ 1)*100;
			$growthweekhour = 100;
		}

		// -------------------------------------------


		$monthend = date('Y-m-d');
		$monthstart = date('Y-m-d', strtotime($monthend. ' - 30 days'));
		$where_currentmonth = array();
		$where_currentmonth['hauling_date >= ' . quotedStr($monthstart) . ''] = null;
		$where_currentmonth['hauling_date <= ' . quotedStr($monthend) . ''] = null;
		$this->hauling_model->set_where($where_currentmonth);
		$totalcurrentmonth = $this->hauling_model->getTotalHauling();
		$totalcurrentmonthhour = ($totalcurrentmonth / (24 * 31)) ; 

		$lastmonthstart = date('Y-m-d', strtotime($monthstart. ' - 31 days'));
		$lastmonthend =  date('Y-m-d', strtotime($monthstart. ' - 1 days'));
		$where_lastmonth = array();
		$where_lastmonth['hauling_date >= ' . quotedStr($lastmonthstart) . ''] = null;
		$where_lastmonth['hauling_date <= ' . quotedStr($lastmonthend) . ''] = null;
		$this->hauling_model->set_where($where_lastmonth);
		$totallastmonth = $this->hauling_model->getTotalHauling();
		$totallastmonthhour = ($totallastmonth / (24 * 31)) ; 

		if($totallastmonth != 0){
			$growthmonth = (($totalcurrentmonth - $totallastmonth)/ $totallastmonth)*100;
		}else{
			$growthmonth = 100;
		}
		if($totallastmonthhour != 0){
			$growthmonthhour = (($totalcurrentmonthhour - $totallastmonthhour)/ $totallastmonthhour)*100;
		}else{
			$growthmonthhour = 100;
		}

		// -------------------------------------------

		$yearend = date('Y-m-d');
		$yearstart = date('Y-m-d', strtotime($yearend. ' - 365 days'));
		$where_currentyear = array();
		$where_currentyear['hauling_date >= ' . quotedStr($yearstart) . ''] = null;
		$where_currentyear['hauling_date <= ' . quotedStr($yearend) . ''] = null;
		$this->hauling_model->set_where($where_currentyear);
		$totalcurrentyear = $this->hauling_model->getTotalHauling();
		$totalcurrentyearhour = ($totalcurrentyear / (24 * 365)) ; 

		$lastyearstart = date('Y-m-d', strtotime($yearstart. ' - 366 days'));
		$lastyearend =  date('Y-m-d', strtotime($yearstart. ' - 1 days'));
		$where_lastyear = array();
		$where_lastyear['hauling_date >= ' . quotedStr($lastyearstart) . ''] = null;
		$where_lastyear['hauling_date <= ' . quotedStr($lastyearend) . ''] = null;
		$this->hauling_model->set_where($where_lastyear);
		$totallastyear = $this->hauling_model->getTotalHauling();
		$totallastyearhour = ($totallastyear / (24 * 365)) ; 

		if($totallastyear != 0){
			$growthyear = (($totalcurrentyear - $totallastyear)/ $totallastyear)*100;
		}else{
			$growthyear = 100;
		}
		if($totallastyearhour != 0){
			$growthyearhour = (($totalcurrentyearhour - $totallastyearhour)/ $totallastyearhour)*100;
		}else{
			$growthyearhour = 100;
		}

		// -------------------------------------------
		
		$data = array(
			'content' => 'hauling_dashboard/table1',
			'totalcurrent' => $totalcurrent,
			'totalyesterday' => $totalyesterday,
			'growthday' => $growthday,
			'totalcurrenthour' => $totalcurrenthour,
			'totalyesterdayhour' => $totalyesterdayhour,
			'growthdayhour' => $growthdayhour,
			'totalcurrentweek' => $totalcurrentweek,
			'totallastweek' => $totallastweek,
			'growthweek' => $growthweek,
			'totalcurrentweekhour' => $totalcurrentweekhour,
			'totallastweekhour' => $totallastweekhour, 
			'growthweekhour' => $growthweekhour,
			'totalcurrentmonth' => $totalcurrentmonth,
			'totalcurrentmonthhour' => $totalcurrentmonthhour,
			'growthmonth' => $growthmonth,
			'totallastmonth' => $totallastmonth,
			'totallastmonthhour' => $totallastmonthhour,
			'growthmonthhour' => $growthmonthhour,
			'totalcurrentyear' => $totalcurrentyear,
			'totalcurrentyearhour' => $totalcurrentyearhour,
			'growthyear' => $growthyear,
			'totallastyear' => $totallastyear,
			'totallastyearhour' => $totallastyearhour,
			'growthyearhour' => $growthyearhour
		);
		$this->load->view($data['content'], $data);
	}

	public function load_table2()
	{
		$currentdate = date('Y-m-d');
		$where_current = array();
		$where_current['hauling_date = ' . quotedStr($currentdate) . ''] = null;
		$this->hauling_model->set_where($where_current);
		$vhcountcurrent = $this->hauling_model->count();
		$vhcountcurrenthour = ($vhcountcurrent / 24) ; 

		$yesterday = date('Y-m-d', strtotime($currentdate. ' - 1 days'));
		$where_yesterday = array();
		$where_yesterday['hauling_date = ' . quotedStr($yesterday) . ''] = null;
		$this->hauling_model->set_where($where_yesterday);
		$vhcountyesterday = $this->hauling_model->count();
		$vhcountyesterdayhour = ($vhcountyesterday / 24);

		if($vhcountyesterday !=0){
			$growthday = (($vhcountcurrent - $vhcountyesterday)/ $vhcountyesterday)*100;
		}else{
			$growthday = 100;
		}
		if($vhcountyesterdayhour !=0){
			$growthdayhour = (($vhcountcurrenthour - $vhcountyesterdayhour)/ $vhcountyesterdayhour)*100;
		}else{
			$growthdayhour = 100;
		}

		// -------------------------------------------

		$weekend = date('Y-m-d');
		$weekstart = date('Y-m-d', strtotime($weekend. ' - 7 days'));
		$where_currentweek = array();
		$where_currentweek['hauling_date >= ' . quotedStr($weekstart) . ''] = null;
		$where_currentweek['hauling_date <= ' . quotedStr($weekend) . ''] = null;
		$this->hauling_model->set_where($where_currentweek);
		$vhcountcurrentweek = $this->hauling_model->count();
		$vhcountcurrentweekhour = ($vhcountcurrentweek / (24 * 7)) ; 

		$lastweekstart =  date('Y-m-d', strtotime($weekstart. ' - 8 days'));
		$lastweeksend =  date('Y-m-d', strtotime($weekstart. ' - 1 days'));
		$where_lastweek = array();
		$where_lastweek['hauling_date >= ' . quotedStr($lastweekstart) . ''] = null;
		$where_lastweek['hauling_date <= ' . quotedStr($lastweeksend) . ''] = null;
		$this->hauling_model->set_where($where_lastweek);
		$vhcountlastweek = $this->hauling_model->count();
		$vhcountlastweekhour = ($vhcountlastweek / (24 * 7)) ; 

		if($vhcountlastweek != 0){
			$growthweek = (($vhcountcurrentweek - $vhcountlastweek)/ $vhcountlastweek)*100;
		}else{
			$growthweek = 100;
		}
		if($vhcountlastweekhour != 0){
			$growthweekhour = (($vhcountcurrentweekhour - $vhcountlastweekhour)/ $vhcountlastweekhour)*100;
		}else{
			$growthweekhour = 100;
		}

		// -------------------------------------------


		$monthend = date('Y-m-d');
		$monthstart = date('Y-m-d', strtotime($monthend. ' - 30 days'));
		$where_currentmonth = array();
		$where_currentmonth['hauling_date >= ' . quotedStr($monthstart) . ''] = null;
		$where_currentmonth['hauling_date <= ' . quotedStr($monthend) . ''] = null;
		$this->hauling_model->set_where($where_currentmonth);
		$vhcountcurrentmonth = $this->hauling_model->count();
		$vhcountcurrentmonthhour = ($vhcountcurrentmonth / (24 * 31)) ; 

		$lastmonthstart = date('Y-m-d', strtotime($monthstart. ' - 31 days'));
		$lastmonthend =  date('Y-m-d', strtotime($monthstart. ' - 1 days'));
		$where_lastmonth = array();
		$where_lastmonth['hauling_date >= ' . quotedStr($lastmonthstart) . ''] = null;
		$where_lastmonth['hauling_date <= ' . quotedStr($lastmonthend) . ''] = null;
		$this->hauling_model->set_where($where_lastmonth);
		$vhcountlastmonth = $this->hauling_model->count();
		$vhcountlastmonthhour = ($vhcountlastmonth / (24 * 31)) ; 

		if($vhcountlastmonth != 0){
			$growthmonth = (($vhcountcurrentmonth - $vhcountlastmonth)/ $vhcountlastmonth)*100;
		}else{
			$growthmonth = 100;
		}
		if($vhcountlastmonthhour != 0){
			$growthmonthhour = (($vhcountcurrentmonthhour - $vhcountlastmonthhour)/ $vhcountlastmonthhour)*100;
		}else{
			$growthmonthhour = 100;
		}

		// -------------------------------------------

		$yearend = date('Y-m-d');
		$yearstart = date('Y-m-d', strtotime($yearend. ' - 365 days'));
		$where_currentyear = array();
		$where_currentyear['hauling_date >= ' . quotedStr($yearstart) . ''] = null;
		$where_currentyear['hauling_date <= ' . quotedStr($yearend) . ''] = null;
		$this->hauling_model->set_where($where_currentyear);
		$vhcountcurrentyear = $this->hauling_model->count();
		$vhcountcurrentyearhour = ($vhcountcurrentyear / (24 * 365)) ; 

		$lastyearstart = date('Y-m-d', strtotime($yearstart. ' - 366 days'));
		$lastyearend =  date('Y-m-d', strtotime($yearstart. ' - 1 days'));
		$where_lastyear = array();
		$where_lastyear['hauling_date >= ' . quotedStr($lastyearstart) . ''] = null;
		$where_lastyear['hauling_date <= ' . quotedStr($lastyearend) . ''] = null;
		$this->hauling_model->set_where($where_lastyear);
		$vhcountlastyear = $this->hauling_model->count();
		$vhcountlastyearhour = ($vhcountlastyear / (24 * 365)) ; 

		if($vhcountlastyear != 0){
			$growthyear = (($vhcountcurrentyear - $vhcountlastyear)/ $vhcountlastyear)*100;
		}else{
			$growthyear = 100;
		}
		if($vhcountlastyearhour != 0){
			$growthyearhour = (($vhcountcurrentyearhour - $vhcountlastyearhour)/ $vhcountlastyearhour)*100;
		}else{
			$growthyearhour = 100;
		}

		// -------------------------------------------
		
		$data = array(
			'content' => 'hauling_dashboard/table2',
			'vhcountcurrent' => $vhcountcurrent,
			'vhcountyesterday' => $vhcountyesterday,
			'growthday' => $growthday,
			'vhcountcurrenthour' => $vhcountcurrenthour,
			'vhcountyesterdayhour' => $vhcountyesterdayhour,
			'growthdayhour' => $growthdayhour,
			'vhcountcurrentweek' => $vhcountcurrentweek,
			'vhcountlastweek' => $vhcountlastweek,
			'growthweek' => $growthweek,
			'vhcountcurrentweekhour' => $vhcountcurrentweekhour,
			'vhcountlastweekhour' => $vhcountlastweekhour, 
			'growthweekhour' => $growthweekhour,
			'vhcountcurrentmonth' => $vhcountcurrentmonth,
			'vhcountcurrentmonthhour' => $vhcountcurrentmonthhour,
			'growthmonth' => $growthmonth,
			'vhcountlastmonth' => $vhcountlastmonth,
			'vhcountlastmonthhour' => $vhcountlastmonthhour,
			'growthmonthhour' => $growthmonthhour,
			'vhcountcurrentyear' => $vhcountcurrentyear,
			'vhcountcurrentyearhour' => $vhcountcurrentyearhour,
			'growthyear' => $growthyear,
			'vhcountlastyear' => $vhcountlastyear,
			'vhcountlastyearhour' => $vhcountlastyearhour,
			'growthyearhour' => $growthyearhour
		);
		$this->load->view($data['content'], $data);
	}
}
