<!DOCTYPE html>
<html>

<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<title>mine-Seal | Login</title>

	<link href="<?= base_url() ?>assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="<?= base_url() ?>assets/font-awesome/css/font-awesome.css" rel="stylesheet">

	<link href="<?= base_url() ?>assets/css/animate.css" rel="stylesheet">
	<link href="<?= base_url() ?>assets/css/style.css" rel="stylesheet">
	<!-- Ladda style -->
	<link href="<?= base_url() ?>assets/css/plugins/ladda/ladda-themeless.min.css" rel="stylesheet">
	<!-- Sweet Alert -->
	<link href="<?= base_url() ?>assets/css/plugins/sweetalert/sweetalert.css" rel="stylesheet">
	<link href="<?= base_url() ?>assets/css/plugins/iCheck/custom.css" rel="stylesheet">

</head>
<style>
	body::after {
		background: url('<?=base_url('assets/img/truck.png')?>');
		content: "";
		opacity: 0.4;
		position: absolute;
		top: 0;
		bottom: 0;
		right: 0;
		left: 0;
		z-index: -1;
		background-size: cover;
	}

	.border-white {
		background-color: #ffffffc4;
		padding-top: 10px;
		border-radius: 10px;
		padding-bottom: 10px;
	}

	.custom-middle-box {
		max-width: 400px;
		z-index: 100;
		margin: 0 auto;
		padding-top: 40px;
	}

	.img-center {
		display: block;
		margin-left: auto;
		margin-right: auto;
		width: 93%;
	}

</style>
<br><br><br><br><br><br>
<body class="green-bg">
	<div class="custom-middle-box text-center loginscreen animated fadeInDown">
		<div class="row border-white">

			<div>
				<h1 class="logo-name"> <img alt="image" class="img-responsive img-center" src="<?=base_url('assets/img/seal.png')?>"> </h1>
			</div> <br>
			<div class="col-md-12">
				<div class="ibox-content" style="border-radius:15px">
					<form class="m-t" role="form" id="form_login">
						<hr>
						<div class="form-group">
							<input id="username" name="t_username" value="<?php if(isset($_COOKIE["rememberMeId"])) { echo $_COOKIE["rememberMeId"]; } ?>" type="text" class="form-control" placeholder="Username" required="">
						</div>
						<div class="form-group">
							<input id="password" name="t_password" type="password" value="<?php if(isset($_COOKIE["rememberMePass"])) { echo $_COOKIE["rememberMePass"]; } ?>" class="form-control" placeholder="Password" required="">
						</div>
						<label class="pull-left"><small><input name="remember" type="checkbox" class="" <?php if(isset($_COOKIE["rememberMeId"])) { ?> checked="checked" <?php } ?>> Remember me </small> </label> 
						<a href="<?= base_url('login/forgot')?>" class="pull-right">
                            <strong class=""><small>Forgot password?</small></strong>
                        </a>
						<br>
						<hr style="padding-top:10px">
						<button type="submit" id="btn_login" class="btn btn-success block full-width m-b">Login</button>
						<hr>
						<p class="hidden text-muted text-center">
							<small>Do not have an account?</small>
						</p>
						<a class="hidden btn btn-sm btn-white btn-block" href="register.html">Create an account</a>
					</form>
					<p class="m-t"> <small>Copyright&copy; 2024</small> </p>
				</div> <br>	
			</div>
		</div>
	</div>

	<!-- Mainly scripts -->
	<script src="<?= base_url() ?>assets/js/jquery-3.1.1.min.js"></script>
	<script src="<?= base_url() ?>assets/js/bootstrap.js"></script>

	<!-- Ladda -->
	<script src="<?= base_url() ?>assets/js/plugins/ladda/spin.min.js"></script>
	<script src="<?= base_url() ?>assets/js/plugins/ladda/ladda.min.js"></script>
	<script src="<?= base_url() ?>assets/js/plugins/ladda/ladda.jquery.min.js"></script>

	<!-- Sweet alert -->
	<script src="<?= base_url() ?>assets/js/plugins/sweetalert/sweetalert.min.js"></script>
	<!-- iCheck -->
	<script src="<?= base_url() ?>assets/js/plugins/iCheck/icheck.min.js"></script>
</body>

</html>
<script type="text/javascript">
	var site_url = "<?= site_url() ?>";
	$(document).ready(function() {
		$('.i-checks').iCheck({
			checkboxClass: 'icheckbox_square-green',
			radioClass: 'iradio_square-green',
		});
		$('#form_login').submit(function(e) {
			e.preventDefault();
			login(e);
		});
		$('#t_username').focus();
	});

	function login(e) {
		var l = $('#btn_login').ladda();
		l.ladda('start');
		$.ajax({
			type: "POST",
			url: site_url + "login/signin/",
			data: $("#form_login").serialize(),
			dataType: 'json',
			success: function(response) {
				if (response['error_msg']) {
					swal(response['header'] || 'error', response['error_msg'] || '', "error");
					l.ladda('stop');
				} else {
					window.location = site_url + response['url'];
				}
			},
			error: function(jqXhr, textStatus, errorThrown) {
				console.log((textStatus));
				l.ladda('stop');
				swal('error', 'please reload the page', "error");
			}
		});
	}
</script>