<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stockroom_movement extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('hauling_model');
		$this->bc->set_title('Stockroom Movement');
		$this->bc->add('Stockroom',base_url().'hauling');
		$this->bc->add('Movement',base_url().'hauling/stockroom_movement');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'movement/main'
		);
		$this->load->view('tpl',$data);
	}

    public function load_table()
	{		
        $table_types = $this->input->post('t_ch_type_periode')?:"custom";
		$start_date = getSQLDate($this->input->post('t_filter_date_start'));
		$end_date = getSQLDate($this->input->post('t_filter_date_end'));

		$first_date = date("Y-m-").'01';    
		$current_date = date("Y-m-d");

		$first_year = date("Y-").'01-01'; 
		$years = date("Y");
		$last_years = date("Y") - 1;
		$prev_last_years = date("Y") - 2;

		$first_last_year = $last_years.'-01-01'; 
		$end_last_year = $last_years.'-12-31'; 

		$stock_types = $this->input->post('t_ch_type_stock')?:"all_stock";
		$stockroom = $this->input->post('t_filter_stockroom')?:'kosong';


        if ($table_types == "monthtodate"){
			if(($stock_types == 'all_stock') && ($stockroom == 'kosong')) {
				$list_mtd = $this->hauling_model->getStockRoomCustomAll($first_date, $current_date);
			}
			if($stock_types == 'selected_stock') {
				$list_mtd = $this->hauling_model->getStockRoomCustombySR($first_date, $current_date, $stockroom);
			}

            $content = 'movement/detail_mtd';
			$data = array(
				'content' => $content,
				'listmtd' => $list_mtd,
			);
        }
        if ($table_types == "lastmonth"){
			if(($stock_types == 'all_stock') && ($stockroom == 'kosong')) {
				$list_lastmonth = $this->hauling_model->getStockRoomLastMonthAll();
			}
			if($stock_types == 'selected_stock') {
				$list_lastmonth = $this->hauling_model->getStockRoomLastMonthbySR($stockroom);
			}
			
            $content = 'movement/detail_lastmonth';
			$data = array(
				'content' => $content,
				'listlastmonth' => $list_lastmonth,
			);
        }
        if ($table_types == "yeartodate"){
			if(($stock_types == 'all_stock') && ($stockroom == 'kosong')) {
				$list_ytd = $this->hauling_model->getStockRoomYeartoDateAll($years, $first_year, $current_date);
			}
			if($stock_types == 'selected_stock') {
				$list_ytd = $this->hauling_model->getStockRoomYeartoDatebySR($years, $first_year, $current_date, $stockroom);
			}

            $content = 'movement/detail_ytd';
			$data = array(
				'content' => $content,
				'listytd' => $list_ytd,
			);
        }
        if ($table_types == "lastyear"){
			if(($stock_types == 'all_stock') && ($stockroom == 'kosong')) {
				$list_lastyear = $this->hauling_model->getStockRoomYeartoDateAll($prev_last_years, $first_last_year, $end_last_year);
			}
			if($stock_types == 'selected_stock') {
				$list_lastyear = $this->hauling_model->getStockRoomYeartoDatebySR($prev_last_years, $first_last_year, $end_last_year, $stockroom);
			}

            $content = 'movement/detail_lastyear';
			$data = array(
				'content' => $content,
				'listlastyear' => $list_lastyear,
			);
        }
        if ($table_types == "custom"){
			if(($stock_types == 'all_stock') && ($stockroom == 'kosong')) {
				$list_custom = $this->hauling_model->getStockRoomCustomAll($start_date, $end_date);
			}
			if($stock_types == 'selected_stock') {
				$list_custom = $this->hauling_model->getStockRoomCustombySR($start_date, $end_date, $stockroom);
			}

			// echo $this->db->last_query();
            $content = 'movement/detail_custom';
			$data = array(
				'content' => $content,
				'listcustom' => $list_custom,
			);
        }
        
		$this->load->view($data['content'], $data);
	}
	

}