
<div class="table-responsive ">
    <table id="listDataTableModal" class="table table-striped table-bordered table-hover" style="width:100%;">
        <thead>
            <tr>
                <th>Trans Num</th>
                <th>Trans Date</th>
                <th>Note</th>
                <th>Account Code</th>
                <th>Account Name</th>
                <th>Debet</th>
                <th>Credit</th>
            </tr>
        </thead>
    </table>
</div>

<script type="text/javascript">
$(document).ready(function() {
	$('#form_filter').submit(function(e) {
		console.log(e);
		refreshDataTable();
		e.preventDefault();
	});

	//getComboStatusFilter();
	var	listDataTableModal = $('#listDataTableModal')
			.on('preXhr.dt', function(e, settings, data) {
				$('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'processing': true,
				'serverSide': true,
                'responsive': true,
                'serverMethod': 'post',
                'ajax': {
                    'async': true,
                    'url': site_url + "main/modal/lookupGeneralLedgerListPage",
                    'beforeSend': function(xhr) {},
                    'data': function(d) {
											d.trans_num = "<?=$trans_num?>"
										},
                    'error': function(jqXhr, textStatus, errorThrown) {
                        var error_message = 'internal error';
                        if (jqXhr.responseJSON !== undefined) {
                            error_message = jqXhr['responseJSON']['message'];
                        }
                        swal.fire('error', error_message, "error");
                        $('.browseBtn').ladda('stop');
                    }
                },
                'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
                "columnDefs": [
                    {
						"render": function(data, type, row) {
							var res = format_date(row['dateJournal']);
							return res;
						},
						"targets": 1,
						"orderable": true
					},
                    {
                        "render": function(data, type, row) {
                            return number_format(row['debet'], 2, ',', '.');
                        },
                        'className': 'text-right',
                        "targets": 5,
                        "orderable": true
                    },
                    {
                        "render": function(data, type, row) {
                            return number_format(row['credit'], 2, ',', '.');
                        },
                        'className': 'text-right',
                        "targets": 6,
                        "orderable": true
                    }
                ],
                'columns': [
                    {
                        data: 'transNum'
                    },
                    {
                        data: 'dateJournal'
                    },
                    {
                        data: 'note'
                    },
                    {
                        data: 'accountCode'
                    },
                    {
                        data: 'accountName'
                    },
                    {
                        data: 'debet'
                    },
                    {
                        data: 'credit'
                    }
                ],
                order: [
                    [1, 'asc']
                ],
                initComplete: function() {},
                drawCallback: function(settings) {
                    $('.browseBtn').ladda('stop');
                    $('.row-elipsis').ellipsis().tooltip();
                },
                buttons: [{
                        extend: 'copy'
                    }
                ],
            });
});

function refreshDataTable() {
	$('#listDataTableModal').DataTable().ajax.reload(null, false);
}
</script>