<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bank_cash_in_payment extends Db_update_model {
	function __construct() {
        $this->schema = 'facc';
        $this->table = 'bankCashInPayment';
        parent::__construct();
        // $this->run();
    }
    function run($forge=null){
        $this->forge = $forge;
        $this->bankCashInPayment();
    }
    
    function bankCashInPayment(){
        $this->fields = array(
                'recNum' => array(
                        'type' => 'int4',
                        'unsigned' => TRUE,
                        'key' => TRUE
                ),
                'transNum' => array(
                        'type' => 'varchar',
                        'constraint' => 50,
                        'default' => '0',
                        'key' => TRUE
                ),
                'invoiceNumber' => array(
                        'type' => 'varchar',
                        'constraint' => 50,
                        'unsigned' => TRUE,
                ),
                'invoiceDate' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),
                'invoiceAmount' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'unsigned' => TRUE,
                ),
                'owing' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'unsigned' => TRUE,
                ),
                'payment' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'unsigned' => TRUE,
                ),
                'businessUnitCode' => array(
                        'type' => 'varchar',
                        'constraint' => '20',
                        'unsigned' => TRUE,
                ),
                'tranStatus' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'createdBy' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'createdDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'modifBy' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'modifDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'payType' => array(
                        'type' => 'varchar',
                        'constraint' => '10',
                        'default' => ''
                ),
                'payRefNum' => array(
                        'type' => 'varchar',
                        'constraint' => '50',
                        'default' => ''
                )
        );
        $this->build();
    }
	
}