<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Overburden_model extends Base_Model
{

	function __construct()
	{

		parent::__construct();
		$this->set_table('overburden');
		$this->set_pk('over_burden_number');
		$this->set_log(false);
	}

	function count()
	{
		$data = array();
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');

		$this->db->where($this->where);
		$this->db->or_like($this->like);

		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
	
		return $query->num_rows();
	}

	function get_list()
	{
		$this->db->select('tbl.*');
		$this->db->select('vnd.vendor_name');
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}

	function getTotalOverburden()
	{
		$this->db->select('ifnull(sum(default_weight),0) as total',false);
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');

		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

        $query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		$query_sum = $query->row_array();
        return  $query_sum['total'];
	}

	function get_list_bymonth()
	{
		$this->db->select('tbl.ob_month');
		$this->db->select('tbl.ob_month_name');
		$this->db->select('ifnull(sum(default_weight),0) as total',false);
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

		if($this->group_by)
		{
			foreach ($this->group_by as $value) {
				$this->db->group_by($value);
			}
		}
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}

	function get_list_byday()
	{
		$this->db->select('tbl.ob_day');
		$this->db->select('ifnull(sum(default_weight),0) as total',false);
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

		if($this->group_by)
		{
			foreach ($this->group_by as $value) {
				$this->db->group_by($value);
			}
		}
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}

	function get_list_byhour()
	{
		$this->db->select('tbl.ob_hour');
		$this->db->select('ifnull(sum(default_weight),0) as total',false);
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);

		if($this->group_by)
		{
			foreach ($this->group_by as $value) {
				$this->db->group_by($value);
			}
		}
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}
	
}
