<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Hauling_inbound extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('hauling_model');
		$this->load->model('master/vehicle_model');
		$this->load->model('master/vendor_model');
		$this->bc->set_title('Hauling Inbound');
		$this->bc->add('Hauling',base_url().'hauling');
		$this->bc->add('Inbound',base_url().'hauling/hauling_inbound');
	}
	
	public function index()
	{
		$this->load->model('master/weight_tmp_model');
		$data['id'] = 1;
        $data['weight'] = 0;
        $data['last_update'] = date('Y-m-d H:i:s');
        $save = $this->weight_tmp_model->save($data);

		$data = array(
			'content' => 'inbound/main'
		);
		$this->load->view('tpl',$data);
	}

	function save()
	{
		$hauling_number = $this->input->post('t_hauling_number')?:'empty';
		$vendor_id = $this->input->post('t_vendor_id');

		$data = array();
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vendor_id'] 			= $vendor_id;
		$data['vehicle_number'] 	= $this->input->post('t_vehicle_number');
		$data['hauling_status']	= 2;
		$data['hauling_date']		= date('Y-m-d');
		$data['hauling_time']		= date('H:i:s');
		$data['gross_weight'] 	 	= $this->input->post('t_gross_weight');
		$data['tare_weight'] 		= $this->input->post('t_tare_weight');
		$data['net_weight'] 		= $this->input->post('t_net_weight');
		$data['id_rec'] 		    = $this->input->post('t_id_rec');
		$data['location_id'] 		= $this->input->post('t_location_id');
		
		if ($hauling_number == 'empty') {
			$prefix =  date('y') . date('m')  . '.HLG.';
			$data['hauling_number'] = $this->hauling_model->gen_transaction_number($prefix);
		} else {
			$data['hauling_number'] = $hauling_number;
		}

		$vendor_data = $this->vendor_model->get(array("vendor_id" => $vendor_id));
		$vendor_mis = $vendor_data['vendor_mis'];
		$data['vendor_mis']  = $vendor_mis;

		$vehicle_data = $this->vehicle_model->get(array('vehicle_id' => $data['vehicle_id'] ));
		$fuel_convertion = $vehicle_data['fuel_convertion']?:0;
		$fuel_totalconv = $fuel_convertion * $data['net_weight'];
		$data['fuel_totalconv'] = $fuel_totalconv ;

		$vendor_subcon = $vehicle_data['vendor_subcon'];
		$data['vendor_subcon']  = $vendor_subcon;

		$this->db->trans_start();
		
		// simpan header
		$save = $this->hauling_model->save($data);
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->result['trxnumber'] 	= $data['hauling_number'];
			$this->result['trxdate'] 	= $data['hauling_date'];
			$this->result['trxtime'] 	= $data['hauling_time'];
			$this->success('Save Success');
		}
	}

	public function getDataHaulingInbound()
	{
		$post = $this->input->post();
		
        $where = array();
        $where['tbl.hauling_number'] = $post['hauling_num'];
		$this->hauling_model->set_where($where);

		$hauling_in = $this->hauling_model->get_list_get($where);
		// echo $this->db->last_query();die;

        if (!$hauling_in['hauling_number']){
            $this->error('Nomor Hauling tidak ditemukan !');
        }

        $this->result['haulingin'] = $hauling_in;
        $this->success('ok');		
	}

	function print_doc_pdf()
	{
		$trx_num = $this->input->post('id');
				
		$where = array();
        $where['tbl.hauling_number'] = $trx_num;
		// $this->mining_model->set_where($where);
		$list_data = $this->hauling_model->get_list_get($where);

		$data = array(
			'content' 	=> 'inbound/print', 
			'list_data'	=> $list_data
		);
		
		$this->load->view($data['content'],$data); 
	}

	function getfromWeight()
	{
		$this->load->model('master/weight_tmp_model');

		$data = $this->weight_tmp_model->get(array("id" => 1));
		$weight = $data['weight'];
		$this->result['weight'] = $weight;
		$this->success('ok');
	}
}