<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Business_partner extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('business_partner_model');
		$this->load->model('business_partner_role_model');
		$this->bc->add('Master',base_url().'master');
		$this->bc->add('Business Partner',base_url().'master/business_partner');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'business_partner/main'
		);
		$this->load->view('tpl',$data);
	}
	
	public function listPage()
	{
		$draw = $this->input->post('draw')?:0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length')?:0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$isActive = $this->input->post('is_active');
		
		$where = array();
		
		$where['tbl.businessUnitCode'] = $this->session->userdata('businessUnitCode');
		$where["(
			tbl.\"businessPartnerCode\" ~* '$searchValue'
			OR tbl.\"businessPartnerName\" ~* '$searchValue'
			OR tbl.\"email\" ~* '$searchValue'
			OR tbl.\"phone\" ~* '$searchValue'
			OR tbl.\"address\" ~* '$searchValue'
		)"] = NULL;
		
		$this->business_partner_model->set_where($where);
		
		$list_count = $this->business_partner_model->count();
		$this->business_partner_model->set_limit($rowperpage);
		$this->business_partner_model->set_offset($start);
		$this->business_partner_model->set_order(array($columnName=>$columnSortOrder));
		$list_data  = $this->business_partner_model->get_list();
		
		$response = array(
		  "post" => $this->input->post(),
		  "draw" => intval($draw),
		  "iTotalRecords" => $list_count,
		  "iTotalDisplayRecords" => $list_count,
		  "aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function input($business_partner_code='',$business_unit='')
	{
		$images_list = array();
		$decoded_business_partner_code = decode($business_partner_code);
		$decoded_business_unit = decode($business_unit);
		$head = $this->business_partner_model->get(array('businessPartnerCode'=>$decoded_business_partner_code,'businessUnitCode'=>$decoded_business_unit));
		$bp_role = $this->business_partner_role_model->get(array('roleCode'=>$head['roleCode']));
		
		$sub_title = 'New Data';
		$action_new = 1;
		if($head['businessPartnerCode'])
		{
			$sub_title = 'Modify Data '.$decoded_business_partner_code.' ('.$decoded_business_unit.')';
			$action_new = 0;
		}
		$data = array(
			'content' => 'business_partner/input'
			,'head' => $head
			,'bp_role' => $bp_role
			,'action_new' => $action_new
		);
		$this->bc->add($sub_title,base_url().'master/business_partner/');

		$this->load->view('tpl',$data);
	}

	public function save()
	{
		$action_new = $this->input->post('t_action_new');
    	$data['businessPartnerCode'] = $this->input->post('t_bpcode');
    	$data['businessPartnerName'] = $this->input->post('t_bpname');
    	$data['city'] = $this->input->post('t_city');
    	$data['zipCode'] = $this->input->post('t_zip_code');
    	$data['address'] = $this->input->post('t_address');
    	$data['email'] = $this->input->post('t_email');
    	$data['phone'] = $this->input->post('t_phone');
    	$data['fax'] = $this->input->post('t_fax');
    	$data['status'] = $this->input->post('t_status');
		$data['businessUnitCode'] = $this->input->post('t_business_unit_code');
		$data['termsPayment'] = $this->input->post('t_terms_pay');
		$data['bankAccountNumber'] = $this->input->post('t_acc_number');
		$data['statusPKP'] = $this->input->post('t_status_pkp');
		$data['npwp'] = $this->input->post('t_npwp');
		$businessPartnerCode = trim($this->input->post('t_bpcode'));
		if(!$businessPartnerCode)
		$this->error('Kode belum di isi');
		if(!$data['businessPartnerName'])
		$this->error('nama belum di isi');
		if($action_new)
		{
			$data['roleCode'] = $this->input->post('t_rolecode');
			if(!$data['roleCode'])
			$this->error('role code belum di isi');
			// cek nomor apakah sudah dipakai jika buat baru
			if(strlen($businessPartnerCode)<4)
			$this->error('Kode kurang dari 4 digit');

			$check_bp = $this->business_partner_model->get(array('businessPartnerCode'=>$businessPartnerCode));
			if($check_bp['businessPartnerCode'])
			$this->error('No '.$businessPartnerCode.' Sudah digunakan');

			$data['businessUnitCode'] = $this->session->userdata('businessUnitCode');;

		}
		$save = $this->business_partner_model->save($data);
		$this->result['business_partner_code'] = encode($data['businessPartnerCode']);
		$this->result['business_unit'] = encode($data['businessUnitCode']);
		$this->success('Simpan Sukses');
	}

	public function get_last_no_urut()
	{
		$last_no = 1;
		$business_unit = $this->session->userdata('businessUnitCode');
		// get last no where roleCode = C and business unit = business unit session
		// $this->business_partner_model->set_where(array('tbl.roleCode'=>'C'));
		// $this->business_partner_model->set_order(array('tbl.businessPartnerCode'=>'DESC'));
		// $this->business_partner_model->set_limit(1);
		// $last_bp = $this->business_partner_model->get_list();
		$last_bp = $this->business_partner_model->get_last_bp();
		$last_data = array();
		$last_vendor = '---';
		if($last_bp->num_rows() === 1)
		{
			$last_bp_row = $last_bp->row_array();
			$last_data = $last_bp_row;
			$bp_code = $last_bp_row['businessPartnerCode'];
			$last_bp_number = substr($bp_code,-5);
			$this->result['last_bp_number'] = $last_bp_number;
			$last_no = $last_bp_number+1;
			$last_vendor = 'last vendor : '.$bp_code.' - '.$last_data['businessPartnerName'];
		}
		$last_no = sprintf('%05s', $last_no);
		$this->result['last_vendor'] = $last_vendor;
		$this->result['last_data'] = $last_data;
		$this->result['last_no'] = $last_no;

		$this->success('ok');
	}

	function check_available_number()
	{
		$businessPartnerCode = trim($this->input->post('bpcode'));
		if(strlen($businessPartnerCode)<4)
		$this->error('Kode kurang dari 4 digit');

		$check_bp = $this->business_partner_model->get(array('businessPartnerCode'=>$businessPartnerCode));
		if($check_bp['businessPartnerCode'])
		$this->error('Kode '.$businessPartnerCode.' Sudah digunakan');
		$this->success('Kode '.$businessPartnerCode.' tersedia');
	}
}