<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bank_cash_in_detail extends Db_update_model {
	function __construct() {
        $this->schema = 'facc';
        $this->table = 'bankCashInDetail';
        parent::__construct();
        // $this->run();
    }
    function run($forge=null){
        $this->forge = $forge;
        $this->bankCashInDetail();
    }
    
    function bankCashInDetail(){
        $this->fields = array(
                'recNum' => array(
                        'type' => 'int4',
                        'unsigned' => TRUE,
                        'key' => TRUE
                ),
                'transNum' => array(
                        'type' => 'varchar',
                        'constraint' => 50,
                        'key' => TRUE
                ),
                'description' => array(
                        'type' => 'varchar',
                        'constraint' => 255,
                        'unsigned' => TRUE,
                ),
                'accountCode' => array(
                        'type' => 'varchar',
                        'constraint' => 20,
                        'unsigned' => TRUE,
                ),
                'accountName' => array(
                        'type' => 'varchar',
                        'constraint' => 100,
                        'unsigned' => TRUE,
                ),
                'amount' => array(
                    'type' => 'numeric',
                    'constraint' => '18,2',
                    'unsigned' => TRUE,
                ),
                'businessUnitCode' => array(
                    'type' => 'varchar',
                    'constraint' => '20',
                    'unsigned' => TRUE,
                ),
                'deptCode' => array(
                    'type' => 'varchar',
                    'constraint' => '20',
                    'unsigned' => TRUE,
                ),               
                'tranStatus' => array(
                        'type' => 'int4',
                        'default' => '0'
                ),
                'createdBy' => array(
                        'type' => 'int4',
                        'default' => '0'
                ),
                'createdDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'modifBy' => array(
                        'type' => 'int4',
                        'default' => '0'
                ),
                'modifDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'amountCredit' => array(
                    'type' => 'numeric',
                    'constraint' => '18,2',
                    'unsigned' => TRUE,
                ),
        );
        $this->build();
    }
	
}