<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Hauling_outbound extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('hauling_model');
		$this->load->model('master/vendor_model');
		$this->bc->set_title('Hauling Outbound');
		$this->bc->add('Hauling',base_url().'hauling');
		$this->bc->add('Outbound',base_url().'hauling/hauling_outbound');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'outbound/main'
		);
		$this->load->view('tpl',$data);
	}

	function save()
	{
		$where = array();
        $where['tbl.vehicle_id'] = $this->input->post('t_vehicle_id');
        $where['tbl.hauling_number'] = 'empty';
		$this->hauling_model->set_where($where);
		$hauling_out = $this->hauling_model->get_list_get($where);	
		$recnum = $hauling_out['id_rec']; 	
		
		$data = array();
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vehicle_number'] 	= $this->input->post('t_vehicle_number');
		$data['default_weight'] 	= $this->input->post('t_default_weight');
		$data['hauling_status']	= 1;
		$data['hauling_out_date']	= date('Y-m-d');
		$data['hauling_out_time']	= date('H:i:s');
		$data['hauling_number']	= 'empty';

		if ($recnum) {
			$data['id_rec']	  = $recnum;
		} else {
			$data['id_rec'] 	  = $this->hauling_model->gen_recnum($data['vehicle_id']);
		}
		
		$this->db->trans_start();
		$save = $this->hauling_model->save($data);
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->success('Simpan Berhasil');
		}
	}

	public function getDataHaulingOutbound()
	{
		$post = $this->input->post();
		
        $where = array();
        $where['tbl.vehicle_id'] = $post['vehicle_id'];
        $where['tbl.hauling_number'] = 'empty';
		$this->hauling_model->set_where($where);

		$order = array();
		$order['tbl.id_rec'] = 'DESC';
		$this->hauling_model->set_order($order);

		$hauling_out = $this->hauling_model->get_list_get($where);
		// echo $this->db->last_query();die;

        if (!$hauling_out['vehicle_id']){
            $this->error('ID Kendaraan Tidak Ditemukan');
        }

		$vendor = $this->vendor_model->get(array('vendor_id' => $hauling_out['vehicle_vendorid']));
        $tgl = date('Y-m-d');
        $jam = date('H:i:s');
        $this->result['haulingout'] = $hauling_out;
        $this->result['vendor_name'] = $vendor['vendor_name'];
        $this->result['tgl'] = $tgl;
        $this->result['jam'] = $jam;
        $this->success('ok');		
	}
}