<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stockroom extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('stockroom_model');
		$this->load->model('vendor_model');
		$this->bc->set_title('Stockroom');
		$this->bc->add('Stockroom',base_url().'stockroom');
		// $this->bc->add('Outbound',base_url().'coalgetting/coal_getting_outbound');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'stockroom/main'
		);
		$this->load->view('tpl',$data);
	}

	function get_stockroom(){
        $post = $this->input->post();
		
        $where = array();
        $where['tbl.stockroom_id'] = $post['stockroom_id'];
        $stockroom = $this->stockroom_model->get($where);
        if (!$stockroom['stockroom_id']){
            $this->error('ID Stockroom Tidak Ditemukan');
        }
        $vendor = $stockroom['vendor_id'];
		$vendor_data = $this->vendor_model->get(array('vendor_id' => $vendor));
        $tgl = date('Y-m-d');
        $jam = date('H:i:s');
        $this->result['vendor_id'] = $vendor;
        $this->result['vendor_name'] = $vendor_data['vendor_name'];
        $this->result['vendor_mis'] = $vendor_data['vendor_mis'];
        $this->result['tgl'] = $tgl;
        $this->result['jam'] = $jam;
        $this->success('ok');
    }

	public function listPage()
	{
		$draw = $this->input->post('draw')?:0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length')?:0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		
		$where = array();
		$where["(
			tbl.stockroom_id LIKE '%$searchValue%'
			OR tbl.warehouse_id LIKE '%$searchValue%'
			OR tbl.vendor_id LIKE '%$searchValue%'
			OR vnd.vendor_name LIKE '%$searchValue%'
		)"] = NULL;
		
		$this->stockroom_model->set_where($where);
		
		$list_count = $this->stockroom_model->count();
		$this->stockroom_model->set_limit($rowperpage);
		$this->stockroom_model->set_offset($start);
		$this->stockroom_model->set_order(array($columnName=>$columnSortOrder));
		$list_data  = $this->stockroom_model->get_list();
		
		$response = array(
		  "post" => $this->input->post(),
		  "draw" => intval($draw),
		  "iTotalRecords" => $list_count,
		  "iTotalDisplayRecords" => $list_count,
		  "aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function input($stockroom_id='')
	{
		$decoded_stockroom_id = decode($stockroom_id);
		$stockroom_data = $this->stockroom_model->get_list_get(array('stockroom_id'=>$decoded_stockroom_id));

		if($stockroom_data['vendor_id']){
			$vendor_name = $stockroom_data['vendor_name'];
		} else {
			$vendor_name = '';
		}
		
		$data = array(
			'content' => 'stockroom/input'
			,'stockroom_data' => $stockroom_data
			,'vendorname' => $vendor_name
		);

		$this->load->view('tpl',$data);
	}

	function save()
	{
		$data = array();
		$data['stockroom_id'] 		= $this->input->post('t_stockroom_id');
		$data['warehouse_id'] 	= $this->input->post('t_warehouse_id');
		$data['vendor_id'] 	= $this->input->post('t_vendor_id');
		$data['stockroom_mineratio'] 	= $this->input->post('t_stockroom_mineratio');
		$data['origin_type'] 	= $this->input->post('t_origin_type');
		
		$this->db->trans_start();		
		// simpan 
		$save = $this->stockroom_model->save($data);
       
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['stockroom_id']);
			$this->success('Save Success');
		}
	}

}