<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\IpMessaging\V1;

use Twilio\Options;
use Twilio\Values;

abstract class ServiceOptions {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $defaultServiceRoleSid The default_service_role_sid
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     * @param bool $readStatusEnabled The read_status_enabled
     * @param bool $reachabilityEnabled The reachability_enabled
     * @param int $typingIndicatorTimeout The typing_indicator_timeout
     * @param int $consumptionReportInterval The consumption_report_interval
     * @param bool $notificationsNewMessageEnabled The
     *                                             notifications.new_message.enabled
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     * @param bool $notificationsAddedToChannelEnabled The
     *                                                 notifications.added_to_channel.enabled
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     * @param bool $notificationsRemovedFromChannelEnabled The
     *                                                     notifications.removed_from_channel.enabled
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     * @param bool $notificationsInvitedToChannelEnabled The
     *                                                   notifications.invited_to_channel.enabled
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     * @param string $preWebhookUrl The pre_webhook_url
     * @param string $postWebhookUrl The post_webhook_url
     * @param string $webhookMethod The webhook_method
     * @param string[] $webhookFilters The webhook_filters
     * @param string $webhooksOnMessageSendUrl The webhooks.on_message_send.url
     * @param string $webhooksOnMessageSendMethod The
     *                                            webhooks.on_message_send.method
     * @param string $webhooksOnMessageUpdateUrl The webhooks.on_message_update.url
     * @param string $webhooksOnMessageUpdateMethod The
     *                                              webhooks.on_message_update.method
     * @param string $webhooksOnMessageRemoveUrl The webhooks.on_message_remove.url
     * @param string $webhooksOnMessageRemoveMethod The
     *                                              webhooks.on_message_remove.method
     * @param string $webhooksOnChannelAddUrl The webhooks.on_channel_add.url
     * @param string $webhooksOnChannelAddMethod The webhooks.on_channel_add.method
     * @param string $webhooksOnChannelDestroyUrl The
     *                                            webhooks.on_channel_destroy.url
     * @param string $webhooksOnChannelDestroyMethod The
     *                                               webhooks.on_channel_destroy.method
     * @param string $webhooksOnChannelUpdateUrl The webhooks.on_channel_update.url
     * @param string $webhooksOnChannelUpdateMethod The
     *                                              webhooks.on_channel_update.method
     * @param string $webhooksOnMemberAddUrl The webhooks.on_member_add.url
     * @param string $webhooksOnMemberAddMethod The webhooks.on_member_add.method
     * @param string $webhooksOnMemberRemoveUrl The webhooks.on_member_remove.url
     * @param string $webhooksOnMemberRemoveMethod The
     *                                             webhooks.on_member_remove.method
     * @param string $webhooksOnMessageSentUrl The webhooks.on_message_sent.url
     * @param string $webhooksOnMessageSentMethod The
     *                                            webhooks.on_message_sent.method
     * @param string $webhooksOnMessageUpdatedUrl The
     *                                            webhooks.on_message_updated.url
     * @param string $webhooksOnMessageUpdatedMethod The
     *                                               webhooks.on_message_updated.method
     * @param string $webhooksOnMessageRemovedUrl The
     *                                            webhooks.on_message_removed.url
     * @param string $webhooksOnMessageRemovedMethod The
     *                                               webhooks.on_message_removed.method
     * @param string $webhooksOnChannelAddedUrl The webhooks.on_channel_added.url
     * @param string $webhooksOnChannelAddedMethod The
     *                                             webhooks.on_channel_added.method
     * @param string $webhooksOnChannelDestroyedUrl The
     *                                              webhooks.on_channel_destroyed.url
     * @param string $webhooksOnChannelDestroyedMethod The
     *                                                 webhooks.on_channel_destroyed.method
     * @param string $webhooksOnChannelUpdatedUrl The
     *                                            webhooks.on_channel_updated.url
     * @param string $webhooksOnChannelUpdatedMethod The
     *                                               webhooks.on_channel_updated.method
     * @param string $webhooksOnMemberAddedUrl The webhooks.on_member_added.url
     * @param string $webhooksOnMemberAddedMethod The
     *                                            webhooks.on_member_added.method
     * @param string $webhooksOnMemberRemovedUrl The webhooks.on_member_removed.url
     * @param string $webhooksOnMemberRemovedMethod The
     *                                              webhooks.on_member_removed.method
     * @param int $limitsChannelMembers The limits.channel_members
     * @param int $limitsUserChannels The limits.user_channels
     * @return UpdateServiceOptions Options builder
     */
    public static function update(string $friendlyName = Values::NONE, string $defaultServiceRoleSid = Values::NONE, string $defaultChannelRoleSid = Values::NONE, string $defaultChannelCreatorRoleSid = Values::NONE, bool $readStatusEnabled = Values::NONE, bool $reachabilityEnabled = Values::NONE, int $typingIndicatorTimeout = Values::NONE, int $consumptionReportInterval = Values::NONE, bool $notificationsNewMessageEnabled = Values::NONE, string $notificationsNewMessageTemplate = Values::NONE, bool $notificationsAddedToChannelEnabled = Values::NONE, string $notificationsAddedToChannelTemplate = Values::NONE, bool $notificationsRemovedFromChannelEnabled = Values::NONE, string $notificationsRemovedFromChannelTemplate = Values::NONE, bool $notificationsInvitedToChannelEnabled = Values::NONE, string $notificationsInvitedToChannelTemplate = Values::NONE, string $preWebhookUrl = Values::NONE, string $postWebhookUrl = Values::NONE, string $webhookMethod = Values::NONE, array $webhookFilters = Values::ARRAY_NONE, string $webhooksOnMessageSendUrl = Values::NONE, string $webhooksOnMessageSendMethod = Values::NONE, string $webhooksOnMessageUpdateUrl = Values::NONE, string $webhooksOnMessageUpdateMethod = Values::NONE, string $webhooksOnMessageRemoveUrl = Values::NONE, string $webhooksOnMessageRemoveMethod = Values::NONE, string $webhooksOnChannelAddUrl = Values::NONE, string $webhooksOnChannelAddMethod = Values::NONE, string $webhooksOnChannelDestroyUrl = Values::NONE, string $webhooksOnChannelDestroyMethod = Values::NONE, string $webhooksOnChannelUpdateUrl = Values::NONE, string $webhooksOnChannelUpdateMethod = Values::NONE, string $webhooksOnMemberAddUrl = Values::NONE, string $webhooksOnMemberAddMethod = Values::NONE, string $webhooksOnMemberRemoveUrl = Values::NONE, string $webhooksOnMemberRemoveMethod = Values::NONE, string $webhooksOnMessageSentUrl = Values::NONE, string $webhooksOnMessageSentMethod = Values::NONE, string $webhooksOnMessageUpdatedUrl = Values::NONE, string $webhooksOnMessageUpdatedMethod = Values::NONE, string $webhooksOnMessageRemovedUrl = Values::NONE, string $webhooksOnMessageRemovedMethod = Values::NONE, string $webhooksOnChannelAddedUrl = Values::NONE, string $webhooksOnChannelAddedMethod = Values::NONE, string $webhooksOnChannelDestroyedUrl = Values::NONE, string $webhooksOnChannelDestroyedMethod = Values::NONE, string $webhooksOnChannelUpdatedUrl = Values::NONE, string $webhooksOnChannelUpdatedMethod = Values::NONE, string $webhooksOnMemberAddedUrl = Values::NONE, string $webhooksOnMemberAddedMethod = Values::NONE, string $webhooksOnMemberRemovedUrl = Values::NONE, string $webhooksOnMemberRemovedMethod = Values::NONE, int $limitsChannelMembers = Values::NONE, int $limitsUserChannels = Values::NONE): UpdateServiceOptions {
        return new UpdateServiceOptions($friendlyName, $defaultServiceRoleSid, $defaultChannelRoleSid, $defaultChannelCreatorRoleSid, $readStatusEnabled, $reachabilityEnabled, $typingIndicatorTimeout, $consumptionReportInterval, $notificationsNewMessageEnabled, $notificationsNewMessageTemplate, $notificationsAddedToChannelEnabled, $notificationsAddedToChannelTemplate, $notificationsRemovedFromChannelEnabled, $notificationsRemovedFromChannelTemplate, $notificationsInvitedToChannelEnabled, $notificationsInvitedToChannelTemplate, $preWebhookUrl, $postWebhookUrl, $webhookMethod, $webhookFilters, $webhooksOnMessageSendUrl, $webhooksOnMessageSendMethod, $webhooksOnMessageUpdateUrl, $webhooksOnMessageUpdateMethod, $webhooksOnMessageRemoveUrl, $webhooksOnMessageRemoveMethod, $webhooksOnChannelAddUrl, $webhooksOnChannelAddMethod, $webhooksOnChannelDestroyUrl, $webhooksOnChannelDestroyMethod, $webhooksOnChannelUpdateUrl, $webhooksOnChannelUpdateMethod, $webhooksOnMemberAddUrl, $webhooksOnMemberAddMethod, $webhooksOnMemberRemoveUrl, $webhooksOnMemberRemoveMethod, $webhooksOnMessageSentUrl, $webhooksOnMessageSentMethod, $webhooksOnMessageUpdatedUrl, $webhooksOnMessageUpdatedMethod, $webhooksOnMessageRemovedUrl, $webhooksOnMessageRemovedMethod, $webhooksOnChannelAddedUrl, $webhooksOnChannelAddedMethod, $webhooksOnChannelDestroyedUrl, $webhooksOnChannelDestroyedMethod, $webhooksOnChannelUpdatedUrl, $webhooksOnChannelUpdatedMethod, $webhooksOnMemberAddedUrl, $webhooksOnMemberAddedMethod, $webhooksOnMemberRemovedUrl, $webhooksOnMemberRemovedMethod, $limitsChannelMembers, $limitsUserChannels);
    }
}

class UpdateServiceOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $defaultServiceRoleSid The default_service_role_sid
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     * @param bool $readStatusEnabled The read_status_enabled
     * @param bool $reachabilityEnabled The reachability_enabled
     * @param int $typingIndicatorTimeout The typing_indicator_timeout
     * @param int $consumptionReportInterval The consumption_report_interval
     * @param bool $notificationsNewMessageEnabled The
     *                                             notifications.new_message.enabled
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     * @param bool $notificationsAddedToChannelEnabled The
     *                                                 notifications.added_to_channel.enabled
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     * @param bool $notificationsRemovedFromChannelEnabled The
     *                                                     notifications.removed_from_channel.enabled
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     * @param bool $notificationsInvitedToChannelEnabled The
     *                                                   notifications.invited_to_channel.enabled
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     * @param string $preWebhookUrl The pre_webhook_url
     * @param string $postWebhookUrl The post_webhook_url
     * @param string $webhookMethod The webhook_method
     * @param string[] $webhookFilters The webhook_filters
     * @param string $webhooksOnMessageSendUrl The webhooks.on_message_send.url
     * @param string $webhooksOnMessageSendMethod The
     *                                            webhooks.on_message_send.method
     * @param string $webhooksOnMessageUpdateUrl The webhooks.on_message_update.url
     * @param string $webhooksOnMessageUpdateMethod The
     *                                              webhooks.on_message_update.method
     * @param string $webhooksOnMessageRemoveUrl The webhooks.on_message_remove.url
     * @param string $webhooksOnMessageRemoveMethod The
     *                                              webhooks.on_message_remove.method
     * @param string $webhooksOnChannelAddUrl The webhooks.on_channel_add.url
     * @param string $webhooksOnChannelAddMethod The webhooks.on_channel_add.method
     * @param string $webhooksOnChannelDestroyUrl The
     *                                            webhooks.on_channel_destroy.url
     * @param string $webhooksOnChannelDestroyMethod The
     *                                               webhooks.on_channel_destroy.method
     * @param string $webhooksOnChannelUpdateUrl The webhooks.on_channel_update.url
     * @param string $webhooksOnChannelUpdateMethod The
     *                                              webhooks.on_channel_update.method
     * @param string $webhooksOnMemberAddUrl The webhooks.on_member_add.url
     * @param string $webhooksOnMemberAddMethod The webhooks.on_member_add.method
     * @param string $webhooksOnMemberRemoveUrl The webhooks.on_member_remove.url
     * @param string $webhooksOnMemberRemoveMethod The
     *                                             webhooks.on_member_remove.method
     * @param string $webhooksOnMessageSentUrl The webhooks.on_message_sent.url
     * @param string $webhooksOnMessageSentMethod The
     *                                            webhooks.on_message_sent.method
     * @param string $webhooksOnMessageUpdatedUrl The
     *                                            webhooks.on_message_updated.url
     * @param string $webhooksOnMessageUpdatedMethod The
     *                                               webhooks.on_message_updated.method
     * @param string $webhooksOnMessageRemovedUrl The
     *                                            webhooks.on_message_removed.url
     * @param string $webhooksOnMessageRemovedMethod The
     *                                               webhooks.on_message_removed.method
     * @param string $webhooksOnChannelAddedUrl The webhooks.on_channel_added.url
     * @param string $webhooksOnChannelAddedMethod The
     *                                             webhooks.on_channel_added.method
     * @param string $webhooksOnChannelDestroyedUrl The
     *                                              webhooks.on_channel_destroyed.url
     * @param string $webhooksOnChannelDestroyedMethod The
     *                                                 webhooks.on_channel_destroyed.method
     * @param string $webhooksOnChannelUpdatedUrl The
     *                                            webhooks.on_channel_updated.url
     * @param string $webhooksOnChannelUpdatedMethod The
     *                                               webhooks.on_channel_updated.method
     * @param string $webhooksOnMemberAddedUrl The webhooks.on_member_added.url
     * @param string $webhooksOnMemberAddedMethod The
     *                                            webhooks.on_member_added.method
     * @param string $webhooksOnMemberRemovedUrl The webhooks.on_member_removed.url
     * @param string $webhooksOnMemberRemovedMethod The
     *                                              webhooks.on_member_removed.method
     * @param int $limitsChannelMembers The limits.channel_members
     * @param int $limitsUserChannels The limits.user_channels
     */
    public function __construct(string $friendlyName = Values::NONE, string $defaultServiceRoleSid = Values::NONE, string $defaultChannelRoleSid = Values::NONE, string $defaultChannelCreatorRoleSid = Values::NONE, bool $readStatusEnabled = Values::NONE, bool $reachabilityEnabled = Values::NONE, int $typingIndicatorTimeout = Values::NONE, int $consumptionReportInterval = Values::NONE, bool $notificationsNewMessageEnabled = Values::NONE, string $notificationsNewMessageTemplate = Values::NONE, bool $notificationsAddedToChannelEnabled = Values::NONE, string $notificationsAddedToChannelTemplate = Values::NONE, bool $notificationsRemovedFromChannelEnabled = Values::NONE, string $notificationsRemovedFromChannelTemplate = Values::NONE, bool $notificationsInvitedToChannelEnabled = Values::NONE, string $notificationsInvitedToChannelTemplate = Values::NONE, string $preWebhookUrl = Values::NONE, string $postWebhookUrl = Values::NONE, string $webhookMethod = Values::NONE, array $webhookFilters = Values::ARRAY_NONE, string $webhooksOnMessageSendUrl = Values::NONE, string $webhooksOnMessageSendMethod = Values::NONE, string $webhooksOnMessageUpdateUrl = Values::NONE, string $webhooksOnMessageUpdateMethod = Values::NONE, string $webhooksOnMessageRemoveUrl = Values::NONE, string $webhooksOnMessageRemoveMethod = Values::NONE, string $webhooksOnChannelAddUrl = Values::NONE, string $webhooksOnChannelAddMethod = Values::NONE, string $webhooksOnChannelDestroyUrl = Values::NONE, string $webhooksOnChannelDestroyMethod = Values::NONE, string $webhooksOnChannelUpdateUrl = Values::NONE, string $webhooksOnChannelUpdateMethod = Values::NONE, string $webhooksOnMemberAddUrl = Values::NONE, string $webhooksOnMemberAddMethod = Values::NONE, string $webhooksOnMemberRemoveUrl = Values::NONE, string $webhooksOnMemberRemoveMethod = Values::NONE, string $webhooksOnMessageSentUrl = Values::NONE, string $webhooksOnMessageSentMethod = Values::NONE, string $webhooksOnMessageUpdatedUrl = Values::NONE, string $webhooksOnMessageUpdatedMethod = Values::NONE, string $webhooksOnMessageRemovedUrl = Values::NONE, string $webhooksOnMessageRemovedMethod = Values::NONE, string $webhooksOnChannelAddedUrl = Values::NONE, string $webhooksOnChannelAddedMethod = Values::NONE, string $webhooksOnChannelDestroyedUrl = Values::NONE, string $webhooksOnChannelDestroyedMethod = Values::NONE, string $webhooksOnChannelUpdatedUrl = Values::NONE, string $webhooksOnChannelUpdatedMethod = Values::NONE, string $webhooksOnMemberAddedUrl = Values::NONE, string $webhooksOnMemberAddedMethod = Values::NONE, string $webhooksOnMemberRemovedUrl = Values::NONE, string $webhooksOnMemberRemovedMethod = Values::NONE, int $limitsChannelMembers = Values::NONE, int $limitsUserChannels = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['defaultServiceRoleSid'] = $defaultServiceRoleSid;
        $this->options['defaultChannelRoleSid'] = $defaultChannelRoleSid;
        $this->options['defaultChannelCreatorRoleSid'] = $defaultChannelCreatorRoleSid;
        $this->options['readStatusEnabled'] = $readStatusEnabled;
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        $this->options['typingIndicatorTimeout'] = $typingIndicatorTimeout;
        $this->options['consumptionReportInterval'] = $consumptionReportInterval;
        $this->options['notificationsNewMessageEnabled'] = $notificationsNewMessageEnabled;
        $this->options['notificationsNewMessageTemplate'] = $notificationsNewMessageTemplate;
        $this->options['notificationsAddedToChannelEnabled'] = $notificationsAddedToChannelEnabled;
        $this->options['notificationsAddedToChannelTemplate'] = $notificationsAddedToChannelTemplate;
        $this->options['notificationsRemovedFromChannelEnabled'] = $notificationsRemovedFromChannelEnabled;
        $this->options['notificationsRemovedFromChannelTemplate'] = $notificationsRemovedFromChannelTemplate;
        $this->options['notificationsInvitedToChannelEnabled'] = $notificationsInvitedToChannelEnabled;
        $this->options['notificationsInvitedToChannelTemplate'] = $notificationsInvitedToChannelTemplate;
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        $this->options['webhookMethod'] = $webhookMethod;
        $this->options['webhookFilters'] = $webhookFilters;
        $this->options['webhooksOnMessageSendUrl'] = $webhooksOnMessageSendUrl;
        $this->options['webhooksOnMessageSendMethod'] = $webhooksOnMessageSendMethod;
        $this->options['webhooksOnMessageUpdateUrl'] = $webhooksOnMessageUpdateUrl;
        $this->options['webhooksOnMessageUpdateMethod'] = $webhooksOnMessageUpdateMethod;
        $this->options['webhooksOnMessageRemoveUrl'] = $webhooksOnMessageRemoveUrl;
        $this->options['webhooksOnMessageRemoveMethod'] = $webhooksOnMessageRemoveMethod;
        $this->options['webhooksOnChannelAddUrl'] = $webhooksOnChannelAddUrl;
        $this->options['webhooksOnChannelAddMethod'] = $webhooksOnChannelAddMethod;
        $this->options['webhooksOnChannelDestroyUrl'] = $webhooksOnChannelDestroyUrl;
        $this->options['webhooksOnChannelDestroyMethod'] = $webhooksOnChannelDestroyMethod;
        $this->options['webhooksOnChannelUpdateUrl'] = $webhooksOnChannelUpdateUrl;
        $this->options['webhooksOnChannelUpdateMethod'] = $webhooksOnChannelUpdateMethod;
        $this->options['webhooksOnMemberAddUrl'] = $webhooksOnMemberAddUrl;
        $this->options['webhooksOnMemberAddMethod'] = $webhooksOnMemberAddMethod;
        $this->options['webhooksOnMemberRemoveUrl'] = $webhooksOnMemberRemoveUrl;
        $this->options['webhooksOnMemberRemoveMethod'] = $webhooksOnMemberRemoveMethod;
        $this->options['webhooksOnMessageSentUrl'] = $webhooksOnMessageSentUrl;
        $this->options['webhooksOnMessageSentMethod'] = $webhooksOnMessageSentMethod;
        $this->options['webhooksOnMessageUpdatedUrl'] = $webhooksOnMessageUpdatedUrl;
        $this->options['webhooksOnMessageUpdatedMethod'] = $webhooksOnMessageUpdatedMethod;
        $this->options['webhooksOnMessageRemovedUrl'] = $webhooksOnMessageRemovedUrl;
        $this->options['webhooksOnMessageRemovedMethod'] = $webhooksOnMessageRemovedMethod;
        $this->options['webhooksOnChannelAddedUrl'] = $webhooksOnChannelAddedUrl;
        $this->options['webhooksOnChannelAddedMethod'] = $webhooksOnChannelAddedMethod;
        $this->options['webhooksOnChannelDestroyedUrl'] = $webhooksOnChannelDestroyedUrl;
        $this->options['webhooksOnChannelDestroyedMethod'] = $webhooksOnChannelDestroyedMethod;
        $this->options['webhooksOnChannelUpdatedUrl'] = $webhooksOnChannelUpdatedUrl;
        $this->options['webhooksOnChannelUpdatedMethod'] = $webhooksOnChannelUpdatedMethod;
        $this->options['webhooksOnMemberAddedUrl'] = $webhooksOnMemberAddedUrl;
        $this->options['webhooksOnMemberAddedMethod'] = $webhooksOnMemberAddedMethod;
        $this->options['webhooksOnMemberRemovedUrl'] = $webhooksOnMemberRemovedUrl;
        $this->options['webhooksOnMemberRemovedMethod'] = $webhooksOnMemberRemovedMethod;
        $this->options['limitsChannelMembers'] = $limitsChannelMembers;
        $this->options['limitsUserChannels'] = $limitsUserChannels;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The default_service_role_sid
     *
     * @param string $defaultServiceRoleSid The default_service_role_sid
     * @return $this Fluent Builder
     */
    public function setDefaultServiceRoleSid(string $defaultServiceRoleSid): self {
        $this->options['defaultServiceRoleSid'] = $defaultServiceRoleSid;
        return $this;
    }

    /**
     * The default_channel_role_sid
     *
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     * @return $this Fluent Builder
     */
    public function setDefaultChannelRoleSid(string $defaultChannelRoleSid): self {
        $this->options['defaultChannelRoleSid'] = $defaultChannelRoleSid;
        return $this;
    }

    /**
     * The default_channel_creator_role_sid
     *
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     * @return $this Fluent Builder
     */
    public function setDefaultChannelCreatorRoleSid(string $defaultChannelCreatorRoleSid): self {
        $this->options['defaultChannelCreatorRoleSid'] = $defaultChannelCreatorRoleSid;
        return $this;
    }

    /**
     * The read_status_enabled
     *
     * @param bool $readStatusEnabled The read_status_enabled
     * @return $this Fluent Builder
     */
    public function setReadStatusEnabled(bool $readStatusEnabled): self {
        $this->options['readStatusEnabled'] = $readStatusEnabled;
        return $this;
    }

    /**
     * The reachability_enabled
     *
     * @param bool $reachabilityEnabled The reachability_enabled
     * @return $this Fluent Builder
     */
    public function setReachabilityEnabled(bool $reachabilityEnabled): self {
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        return $this;
    }

    /**
     * The typing_indicator_timeout
     *
     * @param int $typingIndicatorTimeout The typing_indicator_timeout
     * @return $this Fluent Builder
     */
    public function setTypingIndicatorTimeout(int $typingIndicatorTimeout): self {
        $this->options['typingIndicatorTimeout'] = $typingIndicatorTimeout;
        return $this;
    }

    /**
     * The consumption_report_interval
     *
     * @param int $consumptionReportInterval The consumption_report_interval
     * @return $this Fluent Builder
     */
    public function setConsumptionReportInterval(int $consumptionReportInterval): self {
        $this->options['consumptionReportInterval'] = $consumptionReportInterval;
        return $this;
    }

    /**
     * The notifications.new_message.enabled
     *
     * @param bool $notificationsNewMessageEnabled The
     *                                             notifications.new_message.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageEnabled(bool $notificationsNewMessageEnabled): self {
        $this->options['notificationsNewMessageEnabled'] = $notificationsNewMessageEnabled;
        return $this;
    }

    /**
     * The notifications.new_message.template
     *
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageTemplate(string $notificationsNewMessageTemplate): self {
        $this->options['notificationsNewMessageTemplate'] = $notificationsNewMessageTemplate;
        return $this;
    }

    /**
     * The notifications.added_to_channel.enabled
     *
     * @param bool $notificationsAddedToChannelEnabled The
     *                                                 notifications.added_to_channel.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelEnabled(bool $notificationsAddedToChannelEnabled): self {
        $this->options['notificationsAddedToChannelEnabled'] = $notificationsAddedToChannelEnabled;
        return $this;
    }

    /**
     * The notifications.added_to_channel.template
     *
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelTemplate(string $notificationsAddedToChannelTemplate): self {
        $this->options['notificationsAddedToChannelTemplate'] = $notificationsAddedToChannelTemplate;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.enabled
     *
     * @param bool $notificationsRemovedFromChannelEnabled The
     *                                                     notifications.removed_from_channel.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelEnabled(bool $notificationsRemovedFromChannelEnabled): self {
        $this->options['notificationsRemovedFromChannelEnabled'] = $notificationsRemovedFromChannelEnabled;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.template
     *
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelTemplate(string $notificationsRemovedFromChannelTemplate): self {
        $this->options['notificationsRemovedFromChannelTemplate'] = $notificationsRemovedFromChannelTemplate;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.enabled
     *
     * @param bool $notificationsInvitedToChannelEnabled The
     *                                                   notifications.invited_to_channel.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelEnabled(bool $notificationsInvitedToChannelEnabled): self {
        $this->options['notificationsInvitedToChannelEnabled'] = $notificationsInvitedToChannelEnabled;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.template
     *
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelTemplate(string $notificationsInvitedToChannelTemplate): self {
        $this->options['notificationsInvitedToChannelTemplate'] = $notificationsInvitedToChannelTemplate;
        return $this;
    }

    /**
     * The pre_webhook_url
     *
     * @param string $preWebhookUrl The pre_webhook_url
     * @return $this Fluent Builder
     */
    public function setPreWebhookUrl(string $preWebhookUrl): self {
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        return $this;
    }

    /**
     * The post_webhook_url
     *
     * @param string $postWebhookUrl The post_webhook_url
     * @return $this Fluent Builder
     */
    public function setPostWebhookUrl(string $postWebhookUrl): self {
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        return $this;
    }

    /**
     * The webhook_method
     *
     * @param string $webhookMethod The webhook_method
     * @return $this Fluent Builder
     */
    public function setWebhookMethod(string $webhookMethod): self {
        $this->options['webhookMethod'] = $webhookMethod;
        return $this;
    }

    /**
     * The webhook_filters
     *
     * @param string[] $webhookFilters The webhook_filters
     * @return $this Fluent Builder
     */
    public function setWebhookFilters(array $webhookFilters): self {
        $this->options['webhookFilters'] = $webhookFilters;
        return $this;
    }

    /**
     * The webhooks.on_message_send.url
     *
     * @param string $webhooksOnMessageSendUrl The webhooks.on_message_send.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSendUrl(string $webhooksOnMessageSendUrl): self {
        $this->options['webhooksOnMessageSendUrl'] = $webhooksOnMessageSendUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_send.method
     *
     * @param string $webhooksOnMessageSendMethod The
     *                                            webhooks.on_message_send.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSendMethod(string $webhooksOnMessageSendMethod): self {
        $this->options['webhooksOnMessageSendMethod'] = $webhooksOnMessageSendMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_update.url
     *
     * @param string $webhooksOnMessageUpdateUrl The webhooks.on_message_update.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdateUrl(string $webhooksOnMessageUpdateUrl): self {
        $this->options['webhooksOnMessageUpdateUrl'] = $webhooksOnMessageUpdateUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_update.method
     *
     * @param string $webhooksOnMessageUpdateMethod The
     *                                              webhooks.on_message_update.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdateMethod(string $webhooksOnMessageUpdateMethod): self {
        $this->options['webhooksOnMessageUpdateMethod'] = $webhooksOnMessageUpdateMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_remove.url
     *
     * @param string $webhooksOnMessageRemoveUrl The webhooks.on_message_remove.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemoveUrl(string $webhooksOnMessageRemoveUrl): self {
        $this->options['webhooksOnMessageRemoveUrl'] = $webhooksOnMessageRemoveUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_remove.method
     *
     * @param string $webhooksOnMessageRemoveMethod The
     *                                              webhooks.on_message_remove.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemoveMethod(string $webhooksOnMessageRemoveMethod): self {
        $this->options['webhooksOnMessageRemoveMethod'] = $webhooksOnMessageRemoveMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_add.url
     *
     * @param string $webhooksOnChannelAddUrl The webhooks.on_channel_add.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddUrl(string $webhooksOnChannelAddUrl): self {
        $this->options['webhooksOnChannelAddUrl'] = $webhooksOnChannelAddUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_add.method
     *
     * @param string $webhooksOnChannelAddMethod The webhooks.on_channel_add.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddMethod(string $webhooksOnChannelAddMethod): self {
        $this->options['webhooksOnChannelAddMethod'] = $webhooksOnChannelAddMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroy.url
     *
     * @param string $webhooksOnChannelDestroyUrl The
     *                                            webhooks.on_channel_destroy.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyUrl(string $webhooksOnChannelDestroyUrl): self {
        $this->options['webhooksOnChannelDestroyUrl'] = $webhooksOnChannelDestroyUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroy.method
     *
     * @param string $webhooksOnChannelDestroyMethod The
     *                                               webhooks.on_channel_destroy.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyMethod(string $webhooksOnChannelDestroyMethod): self {
        $this->options['webhooksOnChannelDestroyMethod'] = $webhooksOnChannelDestroyMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_update.url
     *
     * @param string $webhooksOnChannelUpdateUrl The webhooks.on_channel_update.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdateUrl(string $webhooksOnChannelUpdateUrl): self {
        $this->options['webhooksOnChannelUpdateUrl'] = $webhooksOnChannelUpdateUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_update.method
     *
     * @param string $webhooksOnChannelUpdateMethod The
     *                                              webhooks.on_channel_update.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdateMethod(string $webhooksOnChannelUpdateMethod): self {
        $this->options['webhooksOnChannelUpdateMethod'] = $webhooksOnChannelUpdateMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_add.url
     *
     * @param string $webhooksOnMemberAddUrl The webhooks.on_member_add.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddUrl(string $webhooksOnMemberAddUrl): self {
        $this->options['webhooksOnMemberAddUrl'] = $webhooksOnMemberAddUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_add.method
     *
     * @param string $webhooksOnMemberAddMethod The webhooks.on_member_add.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddMethod(string $webhooksOnMemberAddMethod): self {
        $this->options['webhooksOnMemberAddMethod'] = $webhooksOnMemberAddMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_remove.url
     *
     * @param string $webhooksOnMemberRemoveUrl The webhooks.on_member_remove.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemoveUrl(string $webhooksOnMemberRemoveUrl): self {
        $this->options['webhooksOnMemberRemoveUrl'] = $webhooksOnMemberRemoveUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_remove.method
     *
     * @param string $webhooksOnMemberRemoveMethod The
     *                                             webhooks.on_member_remove.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemoveMethod(string $webhooksOnMemberRemoveMethod): self {
        $this->options['webhooksOnMemberRemoveMethod'] = $webhooksOnMemberRemoveMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_sent.url
     *
     * @param string $webhooksOnMessageSentUrl The webhooks.on_message_sent.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSentUrl(string $webhooksOnMessageSentUrl): self {
        $this->options['webhooksOnMessageSentUrl'] = $webhooksOnMessageSentUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_sent.method
     *
     * @param string $webhooksOnMessageSentMethod The
     *                                            webhooks.on_message_sent.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSentMethod(string $webhooksOnMessageSentMethod): self {
        $this->options['webhooksOnMessageSentMethod'] = $webhooksOnMessageSentMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_updated.url
     *
     * @param string $webhooksOnMessageUpdatedUrl The
     *                                            webhooks.on_message_updated.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdatedUrl(string $webhooksOnMessageUpdatedUrl): self {
        $this->options['webhooksOnMessageUpdatedUrl'] = $webhooksOnMessageUpdatedUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_updated.method
     *
     * @param string $webhooksOnMessageUpdatedMethod The
     *                                               webhooks.on_message_updated.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdatedMethod(string $webhooksOnMessageUpdatedMethod): self {
        $this->options['webhooksOnMessageUpdatedMethod'] = $webhooksOnMessageUpdatedMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_removed.url
     *
     * @param string $webhooksOnMessageRemovedUrl The
     *                                            webhooks.on_message_removed.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemovedUrl(string $webhooksOnMessageRemovedUrl): self {
        $this->options['webhooksOnMessageRemovedUrl'] = $webhooksOnMessageRemovedUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_removed.method
     *
     * @param string $webhooksOnMessageRemovedMethod The
     *                                               webhooks.on_message_removed.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemovedMethod(string $webhooksOnMessageRemovedMethod): self {
        $this->options['webhooksOnMessageRemovedMethod'] = $webhooksOnMessageRemovedMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_added.url
     *
     * @param string $webhooksOnChannelAddedUrl The webhooks.on_channel_added.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddedUrl(string $webhooksOnChannelAddedUrl): self {
        $this->options['webhooksOnChannelAddedUrl'] = $webhooksOnChannelAddedUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_added.method
     *
     * @param string $webhooksOnChannelAddedMethod The
     *                                             webhooks.on_channel_added.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddedMethod(string $webhooksOnChannelAddedMethod): self {
        $this->options['webhooksOnChannelAddedMethod'] = $webhooksOnChannelAddedMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroyed.url
     *
     * @param string $webhooksOnChannelDestroyedUrl The
     *                                              webhooks.on_channel_destroyed.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyedUrl(string $webhooksOnChannelDestroyedUrl): self {
        $this->options['webhooksOnChannelDestroyedUrl'] = $webhooksOnChannelDestroyedUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroyed.method
     *
     * @param string $webhooksOnChannelDestroyedMethod The
     *                                                 webhooks.on_channel_destroyed.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyedMethod(string $webhooksOnChannelDestroyedMethod): self {
        $this->options['webhooksOnChannelDestroyedMethod'] = $webhooksOnChannelDestroyedMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_updated.url
     *
     * @param string $webhooksOnChannelUpdatedUrl The
     *                                            webhooks.on_channel_updated.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdatedUrl(string $webhooksOnChannelUpdatedUrl): self {
        $this->options['webhooksOnChannelUpdatedUrl'] = $webhooksOnChannelUpdatedUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_updated.method
     *
     * @param string $webhooksOnChannelUpdatedMethod The
     *                                               webhooks.on_channel_updated.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdatedMethod(string $webhooksOnChannelUpdatedMethod): self {
        $this->options['webhooksOnChannelUpdatedMethod'] = $webhooksOnChannelUpdatedMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_added.url
     *
     * @param string $webhooksOnMemberAddedUrl The webhooks.on_member_added.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddedUrl(string $webhooksOnMemberAddedUrl): self {
        $this->options['webhooksOnMemberAddedUrl'] = $webhooksOnMemberAddedUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_added.method
     *
     * @param string $webhooksOnMemberAddedMethod The
     *                                            webhooks.on_member_added.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddedMethod(string $webhooksOnMemberAddedMethod): self {
        $this->options['webhooksOnMemberAddedMethod'] = $webhooksOnMemberAddedMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_removed.url
     *
     * @param string $webhooksOnMemberRemovedUrl The webhooks.on_member_removed.url
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemovedUrl(string $webhooksOnMemberRemovedUrl): self {
        $this->options['webhooksOnMemberRemovedUrl'] = $webhooksOnMemberRemovedUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_removed.method
     *
     * @param string $webhooksOnMemberRemovedMethod The
     *                                              webhooks.on_member_removed.method
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemovedMethod(string $webhooksOnMemberRemovedMethod): self {
        $this->options['webhooksOnMemberRemovedMethod'] = $webhooksOnMemberRemovedMethod;
        return $this;
    }

    /**
     * The limits.channel_members
     *
     * @param int $limitsChannelMembers The limits.channel_members
     * @return $this Fluent Builder
     */
    public function setLimitsChannelMembers(int $limitsChannelMembers): self {
        $this->options['limitsChannelMembers'] = $limitsChannelMembers;
        return $this;
    }

    /**
     * The limits.user_channels
     *
     * @param int $limitsUserChannels The limits.user_channels
     * @return $this Fluent Builder
     */
    public function setLimitsUserChannels(int $limitsUserChannels): self {
        $this->options['limitsUserChannels'] = $limitsUserChannels;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.IpMessaging.V1.UpdateServiceOptions ' . $options . ']';
    }
}